/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import rocks.xmpp.dns.Message;
import rocks.xmpp.dns.Question;
import rocks.xmpp.dns.ResourceRecord;
import rocks.xmpp.dns.SrvRecord;
import rocks.xmpp.dns.TxtRecord;

public final class DnsResolver {
    private static final Map<Question, Message> CACHE = new ConcurrentHashMap<Question, Message>();

    private DnsResolver() {
    }

    public static List<SrvRecord> resolveSRV(CharSequence service, CharSequence domain, long timeout) throws IOException {
        return DnsResolver.resolve("_" + service + "._tcp.", domain, ResourceRecord.Type.SRV, timeout, resourceRecord -> (SrvRecord)resourceRecord.data);
    }

    public static List<TxtRecord> resolveTXT(CharSequence domain, long timeout) throws IOException {
        return DnsResolver.resolve("_xmppconnect.", domain, ResourceRecord.Type.TXT, timeout, resourceRecord -> (TxtRecord)resourceRecord.data);
    }

    private static <T> List<T> resolve(String prefix, CharSequence domain, ResourceRecord.Type type, long timeout, Function<ResourceRecord, T> mapper) throws IOException {
        try {
            long t = timeout <= 0L ? 1000L : timeout;
            Question question = new Question(prefix + domain, type, ResourceRecord.Class.IN);
            return CACHE.computeIfAbsent(question, key -> {
                Message message = new Message(question);
                try (DatagramChannel channel = DatagramChannel.open();){
                    Throwable throwable;
                    Selector selector;
                    block26: {
                        Message message2;
                        block27: {
                            selector = Selector.open();
                            throwable = null;
                            channel.configureBlocking(false);
                            channel.connect(new InetSocketAddress("8.8.8.8", 53));
                            channel.register(selector, 1);
                            channel.write(ByteBuffer.wrap(message.toByteArray()));
                            if (selector.select(t) <= 0) break block26;
                            ByteBuffer response = ByteBuffer.allocate(512);
                            channel.receive(response);
                            response.flip();
                            Message responseMessage = new Message(response);
                            if (message.id != responseMessage.id) {
                                throw new IOException("DNS message IDs did not match.");
                            }
                            message2 = responseMessage;
                            if (selector == null) return message2;
                            if (throwable == null) break block27;
                            try {
                                selector.close();
                                return message2;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return message2;
                            }
                        }
                        selector.close();
                        return message2;
                    }
                    try {
                        try {
                            throw new SocketTimeoutException();
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (selector == null) throw throwable4;
                        if (throwable == null) {
                            selector.close();
                            throw throwable4;
                        }
                        try {
                            selector.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).getAnswers().stream().map(mapper).collect(Collectors.toList());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

