/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import rocks.xmpp.dns.SrvRecord;
import rocks.xmpp.dns.TxtRecord;

final class ResourceRecord {
    private final String name;
    private final Type type;
    private final Class clazz;
    private final long ttl;
    final Object data;

    ResourceRecord(ByteBuffer data) {
        this.name = ResourceRecord.parse(data);
        this.type = Type.valueOf(data.getShort() & 0xFFFF);
        this.clazz = Class.valueOf(data.getShort() & 0xFFFF);
        this.ttl = (long)data.getInt() & 0xFFFFFFFFL;
        int resourceDataLength = data.getShort() & 0xFFFF;
        if (this.type != null) {
            switch (this.type) {
                case SRV: {
                    this.data = new SrvRecord(data);
                    break;
                }
                case TXT: {
                    this.data = new TxtRecord(data, resourceDataLength);
                    break;
                }
                default: {
                    this.data = null;
                    break;
                }
            }
        } else {
            this.data = null;
        }
    }

    public static String parse(ByteBuffer data) {
        int count = data.get() & 0xFF;
        int offset = data.position();
        StringBuilder sb = new StringBuilder();
        while (count > 0) {
            if ((count & 0xC0) == 192) {
                int off = (count & 0x3F) << 8;
                off = offset == data.position() ? (off += data.get() & 0xFF) : (off += data.get(offset + 1) & 0xFF);
                offset = off;
                count = data.get(offset) & 0xFF;
                continue;
            }
            if (offset == data.position()) {
                byte[] b = new byte[count];
                data.get(b);
                sb.append(new String(b, StandardCharsets.US_ASCII));
                offset += count + 1;
                count = data.get() & 0xFF;
            } else {
                sb.append(new String(data.array(), offset + 1, count, StandardCharsets.US_ASCII));
                count = data.get(offset += count + 1) & 0xFF;
            }
            if (count <= 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(' ').append(this.ttl).append(' ').append((Object)this.clazz);
        if (this.data != null) {
            sb.append(' ').append(this.data);
        }
        return sb.toString();
    }

    static enum Type {
        TXT(16),
        SRV(33);

        final int value;

        private Type(int value) {
            this.value = value;
        }

        static Type valueOf(int value) {
            for (Type v : Type.values()) {
                if (v.value != value) continue;
                return v;
            }
            return null;
        }
    }

    static enum Class {
        IN(1),
        CS(2),
        CH(3),
        HS(4),
        ANY(255);

        final int value;

        private Class(int value) {
            this.value = value;
        }

        static Class valueOf(int value) {
            for (Class v : Class.values()) {
                if (v.value != value) continue;
                return v;
            }
            return null;
        }
    }
}

