/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rsm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetItem;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;

public final class ResultSet<T extends ResultSetItem> {
    private final List<T> items = new ArrayList<T>();
    private final ResultSetManagement resultSetManagement;

    private ResultSet(Collection<T> items, ResultSetManagement resultSetManagement) {
        if (items != null) {
            this.items.addAll(items);
        }
        this.resultSetManagement = resultSetManagement;
    }

    public final List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public final ResultSetManagement getResultSetManagement() {
        return this.resultSetManagement;
    }

    public static <T extends ResultSetItem> ResultSet<T> create(ResultSetProvider<T> resultSetProvider, ResultSetManagement resultSetManagement) {
        if (resultSetManagement != null && resultSetManagement.getMaxSize() != null) {
            if (resultSetManagement.getMaxSize() != 0) {
                if (resultSetManagement.getAfter() != null) {
                    return ResultSet.createResponse(resultSetProvider.getItemsAfter(resultSetManagement.getAfter(), resultSetManagement.getMaxSize()), resultSetProvider);
                }
                if (resultSetManagement.getBefore() != null) {
                    if (!resultSetManagement.getBefore().isEmpty()) {
                        return ResultSet.createResponse(resultSetProvider.getItemsBefore(resultSetManagement.getBefore(), resultSetManagement.getMaxSize()), resultSetProvider);
                    }
                    return ResultSet.createResponse(resultSetProvider.getItems(resultSetProvider.getItemCount() - resultSetManagement.getItemCount(), resultSetManagement.getMaxSize()), resultSetProvider);
                }
                int fromIndex = resultSetManagement.getIndex() != null ? resultSetManagement.getIndex() : 0;
                return ResultSet.createResponse(resultSetProvider.getItems(fromIndex, resultSetManagement.getMaxSize()), resultSetProvider);
            }
            return new ResultSet<T>(null, ResultSetManagement.forCount((int)resultSetProvider.getItemCount()));
        }
        return new ResultSet<T>(resultSetProvider.getItems(), null);
    }

    private static <T extends ResultSetItem> ResultSet<T> createResponse(List<T> result, ResultSetProvider<T> resultSetProvider) {
        ResultSetManagement resultSetManagement = !result.isEmpty() ? ResultSetManagement.forCount((Integer)resultSetProvider.getItemCount(), (Integer)resultSetProvider.indexOf(((ResultSetItem)result.get(0)).getId()), (String)((ResultSetItem)result.get(0)).getId(), (String)((ResultSetItem)result.get(result.size() - 1)).getId()) : ResultSetManagement.forCount((int)resultSetProvider.getItemCount());
        return new ResultSet<T>(result, resultSetManagement);
    }
}

