/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

final class XmppStreamWriter {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"XMPP Writer Thread"));
    private final XmppSession xmppSession;
    private final ScheduledExecutorService executor;
    private final Marshaller marshaller;
    private final XmppDebugger debugger;
    private final String namespace;
    private final StreamManager streamManager;
    private OutputStream outputStream;
    private boolean streamOpened;

    XmppStreamWriter(String namespace, StreamManager streamManager, XmppSession xmppSession) {
        this.namespace = namespace;
        this.xmppSession = xmppSession;
        this.marshaller = xmppSession.createMarshaller();
        this.debugger = xmppSession.getDebugger();
        this.executor = new QueuedScheduledExecutorService(EXECUTOR);
        this.streamManager = streamManager;
    }

    void initialize(int keepAliveInterval) {
        if (keepAliveInterval > 0) {
            this.executor.scheduleAtFixedRate(() -> {
                if (EnumSet.of(XmppSession.Status.CONNECTED, XmppSession.Status.AUTHENTICATED).contains((Object)this.xmppSession.getStatus())) {
                    try {
                        this.outputStream.write(32);
                        this.outputStream.flush();
                    }
                    catch (Exception e) {
                        this.notifyException(e);
                    }
                }
            }, 0L, keepAliveInterval, TimeUnit.SECONDS);
        }
    }

    CompletableFuture<Void> write(StreamElement clientStreamElement, boolean flush) {
        Objects.requireNonNull(clientStreamElement);
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    if (clientStreamElement instanceof Stanza) {
                        this.streamManager.markUnacknowledged((Stanza)clientStreamElement);
                    }
                    try (XMLStreamWriter writer = null;){
                        writer = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(byteArrayOutputStream, StandardCharsets.UTF_8.name()));
                        writer.setDefaultNamespace(this.namespace);
                        this.marshaller.marshal((Object)clientStreamElement, writer);
                        writer.flush();
                    }
                    this.write(byteArrayOutputStream.toByteArray());
                    if (flush) {
                        this.outputStream.flush();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    XmppStreamWriter.$closeResource(throwable, byteArrayOutputStream);
                }
            }
            catch (Exception e) {
                this.notifyException(e);
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    CompletionStage<Void> openStream(OutputStream outputStream, StreamHeader streamHeader) {
        return CompletableFuture.runAsync(() -> {
            this.outputStream = outputStream;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Throwable throwable = null;
                try (XMLStreamWriter writer = null;){
                    writer = this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(byteArrayOutputStream, StandardCharsets.UTF_8.name());
                    this.streamOpened = false;
                    streamHeader.writeTo(writer);
                    this.write(byteArrayOutputStream.toByteArray());
                    outputStream.flush();
                    this.streamOpened = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    XmppStreamWriter.$closeResource(throwable, byteArrayOutputStream);
                }
            }
            catch (Exception e) {
                this.notifyException(e);
            }
        }, this.executor);
    }

    private CompletableFuture<Void> closeStream() {
        return CompletableFuture.runAsync(() -> {
            if (this.streamOpened) {
                try {
                    this.write(StreamHeader.CLOSING_STREAM_TAG.toString().getBytes(StandardCharsets.UTF_8));
                    this.outputStream.flush();
                    this.streamOpened = false;
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            }
        }, this.executor);
    }

    private void write(byte[] bytes) throws IOException {
        if (this.debugger != null) {
            this.debugger.writeStanza(new String(bytes, StandardCharsets.UTF_8).trim(), null);
        }
        this.outputStream.write(bytes);
    }

    void flush() {
        this.executor.execute(() -> {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                this.xmppSession.notifyException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Exception exception) {
        XmppStreamWriter xmppStreamWriter = this;
        synchronized (xmppStreamWriter) {
            this.executor.shutdown();
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (Exception e) {
                    exception.addSuppressed(e);
                }
            }
        }
        this.xmppSession.notifyException(exception);
    }

    CompletableFuture<Void> shutdown() {
        return this.closeStream().whenCompleteAsync((aVoid, throwable) -> {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        });
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

