/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.tls.client;

import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.client.ClientStreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

public final class StartTlsManager
extends ClientStreamFeatureNegotiator<StartTls> {
    private final TcpBinding tcpBinding;
    private final ChannelEncryption channelEncryption;

    public StartTlsManager(XmppSession xmppSession, TcpBinding tcpBinding, ChannelEncryption channelEncryption) {
        super(xmppSession, StartTls.class);
        this.tcpBinding = tcpBinding;
        this.channelEncryption = channelEncryption;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        if (element instanceof StartTls) {
            StartTls startTls = (StartTls)element;
            if (startTls.isMandatory() && this.channelEncryption == ChannelEncryption.DISABLED) {
                throw new StreamNegotiationException("The server requires TLS, but you disabled it.");
            }
            if (this.channelEncryption != ChannelEncryption.OPTIONAL && this.channelEncryption != ChannelEncryption.REQUIRED) return StreamNegotiationResult.IGNORE;
            this.xmppSession.send((StreamElement)new StartTls());
            return StreamNegotiationResult.INCOMPLETE;
        }
        if (element instanceof Proceed) {
            try {
                this.tcpBinding.secureConnection();
                return StreamNegotiationResult.RESTART;
            }
            catch (Exception e) {
                throw new StreamNegotiationException((Throwable)e);
            }
        }
        if (!(element instanceof Failure)) return StreamNegotiationResult.INCOMPLETE;
        throw new StreamNegotiationException("Failure during TLS negotiation.");
    }

    public boolean canProcess(Object element) {
        return element instanceof Proceed || element instanceof Failure;
    }
}

