/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import rocks.xmpp.dns.Message;
import rocks.xmpp.dns.Question;
import rocks.xmpp.dns.ResourceRecord;
import rocks.xmpp.dns.SrvRecord;
import rocks.xmpp.dns.TxtRecord;

public final class DnsResolver {
    private static final Map<Question, Message> CACHE = new ConcurrentHashMap<Question, Message>();

    private DnsResolver() {
    }

    public static List<SrvRecord> resolveSRV(CharSequence service, CharSequence domain, String nameServer, long timeout) throws IOException {
        return DnsResolver.resolve("_" + service + "._tcp.", domain, ResourceRecord.Type.SRV, nameServer, timeout, resourceRecord -> (SrvRecord)resourceRecord.data);
    }

    @Deprecated
    public static List<SrvRecord> resolveSRV(CharSequence service, CharSequence domain, long timeout) throws IOException {
        return DnsResolver.resolveSRV(service, domain, null, timeout);
    }

    public static List<TxtRecord> resolveTXT(CharSequence domain, String nameServer, long timeout) throws IOException {
        return DnsResolver.resolve("_xmppconnect.", domain, ResourceRecord.Type.TXT, nameServer, timeout, resourceRecord -> (TxtRecord)resourceRecord.data);
    }

    @Deprecated
    public static List<TxtRecord> resolveTXT(CharSequence domain, long timeout) throws IOException {
        return DnsResolver.resolveTXT(domain, null, timeout);
    }

    private static <T> List<T> resolve(String prefix, CharSequence domain, ResourceRecord.Type type, String nameServer, long timeout, Function<ResourceRecord, T> mapper) throws IOException {
        try {
            long t = timeout <= 0L ? 1000L : timeout;
            Question question = new Question(prefix + domain, type, ResourceRecord.Classification.IN);
            return CACHE.computeIfAbsent(question, key -> {
                Message message = new Message(question);
                try {
                    DatagramChannel channel = DatagramChannel.open();
                    Throwable throwable = null;
                    try {
                        Throwable throwable2;
                        Selector selector;
                        block15: {
                            selector = Selector.open();
                            throwable2 = null;
                            channel.configureBlocking(false);
                            channel.connect(new InetSocketAddress(nameServer == null ? "8.8.8.8" : nameServer, 53));
                            channel.register(selector, 1);
                            channel.write(ByteBuffer.wrap(message.toByteArray()));
                            if (selector.select(t) <= 0) break block15;
                            ByteBuffer response = ByteBuffer.allocate(512);
                            channel.receive(response);
                            response.flip();
                            Message responseMessage = new Message(response);
                            if (message.id != responseMessage.id) {
                                throw new IOException("DNS message IDs did not match.");
                            }
                            Message message2 = responseMessage;
                            if (selector == null) return message2;
                            DnsResolver.$closeResource(throwable2, selector);
                            return message2;
                        }
                        try {
                            try {
                                throw new SocketTimeoutException();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (selector == null) throw throwable4;
                            DnsResolver.$closeResource(throwable2, selector);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (channel != null) {
                            DnsResolver.$closeResource(throwable, channel);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).getAnswers().stream().map(mapper).collect(Collectors.toList());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

