/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Extension;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.rsm.ResultSet;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;
import rocks.xmpp.util.concurrent.CompletionStages;

public final class ServiceDiscoveryManager
extends Manager {
    private static final Set<Identity> DEFAULT_IDENTITY = Collections.singleton(Identity.clientPc());
    private final Set<Identity> identities = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> features = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CopyOnWriteArrayList<DataForm> extensions = new CopyOnWriteArrayList();
    private final Map<String, InfoNode> infoNodeMap = new ConcurrentHashMap<String, InfoNode>();
    private final Map<String, ResultSetProvider<Item>> itemProviders = new ConcurrentHashMap<String, ResultSetProvider<Item>>();
    private final Set<Consumer<EventObject>> capabilitiesChangeListeners = new CopyOnWriteArraySet<Consumer<EventObject>>();
    private final IQHandler discoInfoHandler;
    private final IQHandler discoItemHandler;
    private final Map<String, Extension> featureToExtension = new HashMap<String, Extension>();
    private final Map<Class<? extends Manager>, Set<Extension>> managersToExtensions = new HashMap<Class<? extends Manager>, Set<Extension>>();

    private ServiceDiscoveryManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.discoInfoHandler = new AbstractIQHandler(new IQ.Type[]{IQ.Type.GET}){

            protected IQ processRequest(IQ iq) {
                InfoDiscovery infoDiscovery = (InfoDiscovery)iq.getExtension(InfoDiscovery.class);
                if (infoDiscovery.getNode() == null) {
                    return iq.createResult((Object)new InfoDiscovery(ServiceDiscoveryManager.this.getIdentities(), ServiceDiscoveryManager.this.getFeatures(), ServiceDiscoveryManager.this.getExtensions()));
                }
                InfoNode infoNode = (InfoNode)ServiceDiscoveryManager.this.infoNodeMap.get(infoDiscovery.getNode());
                if (infoNode != null) {
                    return iq.createResult((Object)new InfoDiscovery(infoNode.getNode(), (Collection)infoNode.getIdentities(), (Collection)infoNode.getFeatures(), (Collection)infoNode.getExtensions()));
                }
                return iq.createError(Condition.FEATURE_NOT_IMPLEMENTED);
            }
        };
        this.discoItemHandler = new AbstractIQHandler(new IQ.Type[]{IQ.Type.GET}){

            protected IQ processRequest(IQ iq) {
                ItemDiscovery itemDiscovery = (ItemDiscovery)iq.getExtension(ItemDiscovery.class);
                ResultSetProvider itemProvider = (ResultSetProvider)ServiceDiscoveryManager.this.itemProviders.get(itemDiscovery.getNode() == null ? "" : itemDiscovery.getNode());
                if (itemProvider != null) {
                    ResultSet resultSet = ResultSet.create((ResultSetProvider)itemProvider, (ResultSetManagement)itemDiscovery.getResultSetManagement());
                    return iq.createResult((Object)new ItemDiscovery(itemDiscovery.getNode(), (Collection)resultSet.getItems(), resultSet.getResultSetManagement()));
                }
                if (itemDiscovery.getNode() == null) {
                    return iq.createResult((Object)new ItemDiscovery(itemDiscovery.getNode()));
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        };
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(InfoDiscovery.class, this.discoInfoHandler);
        this.xmppSession.addIQHandler(ItemDiscovery.class, this.discoItemHandler);
    }

    @Override
    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(InfoDiscovery.class);
        this.xmppSession.removeIQHandler(ItemDiscovery.class);
    }

    public final void addCapabilitiesChangeListener(Consumer<EventObject> listener) {
        this.capabilitiesChangeListeners.add(listener);
    }

    public final void removeCapabilitiesChangeListener(Consumer<EventObject> listener) {
        this.capabilitiesChangeListeners.remove(listener);
    }

    public final List<Item> getItems() {
        ResultSetProvider<Item> rootItemProvider = this.itemProviders.get("");
        if (rootItemProvider != null) {
            return Collections.unmodifiableList(rootItemProvider.getItems());
        }
        return Collections.emptyList();
    }

    public final Set<Identity> getIdentities() {
        return this.identities.isEmpty() ? DEFAULT_IDENTITY : Collections.unmodifiableSet(new HashSet<Identity>(this.identities));
    }

    public final Set<String> getFeatures() {
        return Collections.unmodifiableSet(new HashSet<String>(this.features));
    }

    public final List<DataForm> getExtensions() {
        return Collections.unmodifiableList((List)this.extensions.clone());
    }

    public final void addIdentity(Identity identity) {
        if (this.identities.add(identity) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
        }
    }

    public final void removeIdentity(Identity identity) {
        if (this.identities.remove(identity) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
        }
    }

    public final void addFeature(String feature) {
        if (this.features.add(feature)) {
            Extension extension = this.featureToExtension.get(feature);
            this.setEnabled(extension != null ? Collections.singleton(extension) : null, feature, true);
            if (this.xmppSession.isConnected()) {
                XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
            }
        }
    }

    public final void removeFeature(String feature) {
        if (this.features.remove(feature)) {
            Extension extension = this.featureToExtension.get(feature);
            this.setEnabled(extension != null ? Collections.singleton(extension) : null, feature, false);
            if (this.xmppSession.isConnected()) {
                XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
            }
        }
    }

    public final void addFeature(Class<? extends Manager> managerClass) {
        this.setEnabled((Iterable<Extension>)this.managersToExtensions.get(managerClass), null, true);
    }

    public final void removeFeature(Class<? extends Manager> managerClass) {
        this.setEnabled((Iterable<Extension>)this.managersToExtensions.get(managerClass), null, false);
    }

    public final void addExtension(DataForm extension) {
        if (this.extensions.add(extension) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
        }
    }

    public final void removeExtension(DataForm extension) {
        if (this.extensions.remove(extension) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject(this));
        }
    }

    public final AsyncResult<InfoNode> discoverInformation(Jid jid) {
        return this.discoverInformation(jid, null);
    }

    public final AsyncResult<InfoNode> discoverInformation(Jid jid, String node) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new InfoDiscovery(node)), InfoNode.class);
    }

    public final AsyncResult<ItemNode> discoverItems(Jid jid) {
        return this.discoverItems(jid, null, null);
    }

    public final AsyncResult<ItemNode> discoverItems(Jid jid, ResultSetManagement resultSet) {
        return this.discoverItems(jid, null, resultSet);
    }

    public final AsyncResult<ItemNode> discoverItems(Jid jid, String node) {
        return this.discoverItems(jid, node, null);
    }

    public final AsyncResult<ItemNode> discoverItems(Jid jid, String node, ResultSetManagement resultSetManagement) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new ItemDiscovery(node, resultSetManagement)), ItemNode.class);
    }

    public final AsyncResult<List<Item>> discoverServices(Identity identity) {
        return this.discoverServices((InfoNode infoNode) -> {
            for (Identity id : infoNode.getIdentities()) {
                if (!id.getCategory().equals(identity.getCategory()) || !id.getType().equals(identity.getType())) continue;
                return true;
            }
            return false;
        });
    }

    public final AsyncResult<List<Item>> discoverServices(String feature) {
        return this.discoverServices((InfoNode infoNode) -> infoNode.getFeatures().contains(feature));
    }

    private AsyncResult<List<Item>> discoverServices(Predicate<InfoNode> predicate) {
        return this.discoverItems(this.xmppSession.getDomain()).thenCompose(itemDiscovery -> {
            Collection stages = itemDiscovery.getItems().stream().map(item -> this.discoverInformation(item.getJid()).thenApply(infoDiscovery -> {
                if (predicate.test((InfoNode)infoDiscovery)) {
                    return Collections.singletonList(item);
                }
                return Collections.emptyList();
            }).handle((items, throwable) -> {
                if (throwable != null) {
                    return Collections.emptyList();
                }
                return items;
            })).collect(Collectors.toList());
            return CompletionStages.allOf((Collection)stages);
        });
    }

    public final void addInfoNode(InfoNode infoNode) {
        this.infoNodeMap.put(infoNode.getNode(), infoNode);
    }

    public final void removeInfoNode(String node) {
        this.infoNodeMap.remove(node);
    }

    public final void setItemProvider(ResultSetProvider<Item> itemProvider) {
        if (itemProvider == null) {
            this.itemProviders.remove("");
        } else {
            this.itemProviders.put("", itemProvider);
        }
    }

    public final void setItemProvider(String node, ResultSetProvider<Item> itemProvider) {
        if (itemProvider == null) {
            this.itemProviders.remove(node);
        } else {
            this.itemProviders.put(node, itemProvider);
        }
    }

    @Override
    protected void dispose() {
        this.capabilitiesChangeListeners.clear();
        this.infoNodeMap.clear();
        this.itemProviders.clear();
    }

    private void setEnabled(Iterable<Extension> extensions, String feature, boolean enabled) {
        if (extensions != null) {
            for (Extension extension : extensions) {
                Class<? extends Manager> managerClass = extension.getManager();
                if (managerClass != null) {
                    Manager manager = this.xmppSession.getManager(managerClass);
                    boolean mayDisable = true;
                    if (feature != null && !enabled) {
                        Set<Extension> ex = this.managersToExtensions.get(managerClass);
                        for (Extension e : ex) {
                            if (!this.features.contains(e.getNamespace())) continue;
                            mayDisable = false;
                            break;
                        }
                    }
                    if (mayDisable && enabled != manager.isEnabled()) {
                        manager.setEnabled(enabled);
                    }
                }
                this.enableFeature(extension.getNamespace(), enabled);
                for (String subFeature : extension.getFeatures()) {
                    this.enableFeature(subFeature, enabled);
                }
            }
        } else {
            this.enableFeature(feature, enabled);
        }
    }

    private void enableFeature(String feature, boolean enabled) {
        if (feature != null) {
            if (enabled) {
                this.addFeature(feature);
            } else {
                this.removeFeature(feature);
            }
        }
    }

    public final void registerFeature(Extension extension) {
        if (extension.getNamespace() != null) {
            this.featureToExtension.put(extension.getNamespace(), extension);
        }
        if (extension.getManager() != null) {
            Set extensions = this.managersToExtensions.computeIfAbsent(extension.getManager(), key -> new HashSet());
            extensions.add(extension);
        }
        if (extension.isEnabled()) {
            this.setEnabled(Collections.singleton(extension), null, true);
        }
    }
}

