/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.TxtRecord;
import rocks.xmpp.extensions.httpbind.BoshConnection;

public final class BoshConnectionConfiguration
extends ClientConnectionConfiguration {
    private static volatile BoshConnectionConfiguration defaultConfiguration;
    private final Duration wait;
    private final String path;
    private final String route;
    private final boolean useKeySequence;

    private BoshConnectionConfiguration(Builder builder) {
        super(builder);
        this.wait = builder.wait;
        this.path = builder.path;
        this.route = builder.route;
        this.useKeySequence = builder.useKeySequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BoshConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = BoshConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(BoshConnectionConfiguration configuration) {
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Connection createConnection(XmppSession xmppSession) throws Exception {
        URL url;
        int targetPort;
        String protocol;
        String string = protocol = this.getChannelEncryption() == ChannelEncryption.DIRECT ? "https" : "http";
        int n = this.getPort() > 0 ? this.getPort() : (targetPort = this.getChannelEncryption() == ChannelEncryption.DIRECT ? 5281 : 5280);
        if (this.getHostname() != null) {
            url = new URL(protocol, this.getHostname(), targetPort, this.getPath());
        } else if (xmppSession.getDomain() != null) {
            String resolvedUrl = BoshConnectionConfiguration.findBoshUrl(xmppSession.getDomain().toString(), xmppSession.getConfiguration().getNameServer(), this.getConnectTimeout());
            url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, xmppSession.getDomain().toString(), targetPort, this.getPath());
        } else {
            throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
        }
        BoshConnection boshConnection = new BoshConnection(url, xmppSession, this);
        boshConnection.connect();
        return boshConnection;
    }

    private static String findBoshUrl(String xmppServiceDomain, String nameServer, long timeout) {
        try {
            List<TxtRecord> txtRecords = DnsResolver.resolveTXT(xmppServiceDomain, nameServer, timeout);
            for (TxtRecord txtRecord : txtRecords) {
                Map<String, String> attributes = txtRecord.asAttributes();
                String url = attributes.get("_xmpp-client-xbosh");
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public final Duration getWait() {
        return this.wait;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getRoute() {
        return this.route;
    }

    public final boolean isUseKeySequence() {
        return this.useKeySequence;
    }

    @Override
    public final String toString() {
        return "BOSH connection configuration: " + (this.getChannelEncryption() == ChannelEncryption.DIRECT ? "https" : "http") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ClientConnectionConfiguration.Builder<Builder> {
        private Duration wait;
        private String path;
        private String route;
        private boolean useKeySequence;

        private Builder() {
            this.channelEncryption(ChannelEncryption.DISABLED);
            this.wait(Duration.ofMinutes(1L));
            this.path("/http-bind/");
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder wait(Duration wait) {
            this.wait = wait;
            return this;
        }

        @Deprecated
        public Builder wait(int wait) {
            this.wait = Duration.ofSeconds(wait);
            return this;
        }

        public Builder route(String route) {
            this.route = route;
            return this;
        }

        public Builder useKeySequence(boolean useKeySequence) {
            this.useKeySequence = useKeySequence;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoshConnectionConfiguration build() {
            if (this.proxy != null && this.proxy.type() != Proxy.Type.HTTP && this.proxy.type() != Proxy.Type.DIRECT) {
                throw new UnsupportedOperationException("Non-HTTP proxies are not supported by BOSH connections.");
            }
            if (this.channelEncryption != ChannelEncryption.DISABLED && this.channelEncryption != ChannelEncryption.DIRECT) {
                throw new IllegalArgumentException("BOSH connections only support ChannelEncryption.DIRECT (https) or ChannelEncryption.DISABLED (http).");
            }
            return new BoshConnectionConfiguration(this);
        }
    }
}

