/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.net.URI;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.extensions.httpbind.model.Body;

public final class BoshException
extends XmppException {
    private final Body.Condition condition;
    private URI uri;
    private int httpErrorCode;

    BoshException(Body.Condition condition) {
        this(condition, null);
    }

    BoshException(Body.Condition condition, int httpErrorCode) {
        super("The connection was terminated due to HTTP error " + httpErrorCode);
        this.condition = condition;
        this.httpErrorCode = httpErrorCode;
    }

    BoshException(Body.Condition condition, URI uri) {
        super("The connection was terminated with condition: " + (condition != null ? condition.toString() : Body.Condition.UNDEFINED_CONDITION.toString()));
        this.uri = uri;
        this.condition = condition;
    }

    public final Body.Condition getCondition() {
        return this.condition;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final int getHttpErrorCode() {
        return this.httpErrorCode;
    }
}

