/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.roster;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.extensions.privatedata.PrivateDataManager;
import rocks.xmpp.extensions.privatedata.rosterdelimiter.model.RosterDelimiter;
import rocks.xmpp.im.roster.RosterEvent;
import rocks.xmpp.im.roster.model.Contact;
import rocks.xmpp.im.roster.model.ContactGroup;
import rocks.xmpp.im.roster.model.Roster;
import rocks.xmpp.im.roster.model.SubscriptionState;
import rocks.xmpp.im.roster.versioning.model.RosterVersioning;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class RosterManager
extends Manager {
    private static final Logger logger = Logger.getLogger(RosterManager.class.getName());
    private final Map<Jid, Contact> contactMap = new ConcurrentHashMap<Jid, Contact>();
    private final Set<Consumer<RosterEvent>> rosterListeners = new CopyOnWriteArraySet<Consumer<RosterEvent>>();
    private final Map<String, byte[]> rosterCacheDirectory;
    private final TreeSet<ContactGroup> groups = new TreeSet();
    private final TreeSet<Contact> unaffiliatedContacts = new TreeSet();
    private final Map<String, ContactGroup> rosterGroupMap = new HashMap<String, ContactGroup>();
    private final PrivateDataManager privateDataManager;
    private boolean retrieveRosterOnLogin = true;
    private boolean askForGroupDelimiter;
    private String groupDelimiter;

    private RosterManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.privateDataManager = xmppSession.getManager(PrivateDataManager.class);
        this.rosterCacheDirectory = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("rosterver")) : null;
    }

    private static Collection<Contact> collectAllContactsInGroup(ContactGroup contactGroup) {
        ArrayDeque<Contact> contacts = new ArrayDeque<Contact>();
        for (Contact contact : contactGroup.getContacts()) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        ArrayDeque<Contact> contactsInSubGroups = new ArrayDeque<Contact>();
        for (ContactGroup subGroup : contactGroup.getGroups()) {
            contactsInSubGroups.addAll(RosterManager.collectAllContactsInGroup(subGroup));
        }
        for (Contact contact : contactsInSubGroups) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        return contacts;
    }

    private static void addContactIfNotExists(Contact contact, Collection<Contact> contacts) {
        boolean contactExists = false;
        for (Contact c : contacts) {
            if (!c.getJid().equals(contact.getJid())) continue;
            contactExists = true;
        }
        if (!contactExists) {
            contacts.add(contact);
        }
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addIQHandler(Roster.class, (IQHandler)new AbstractIQHandler(new IQ.Type[]{IQ.Type.SET}){

            public IQ processRequest(IQ iq) {
                Roster roster = (Roster)iq.getExtension(Roster.class);
                if (iq.getFrom() == null || iq.getFrom().equals(RosterManager.this.xmppSession.getConnectedResource().asBareJid())) {
                    RosterManager.this.updateRoster(roster, true);
                    return iq.createResult();
                }
                return iq.createError(Condition.SERVICE_UNAVAILABLE);
            }
        }, false);
    }

    public final Collection<Contact> getContacts() {
        return Collections.unmodifiableCollection(new ArrayDeque<Contact>(this.contactMap.values()));
    }

    public final Contact getContact(Jid jid) {
        return this.contactMap.get(Objects.requireNonNull(jid, "jid must not be null").asBareJid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoster(Roster roster, boolean isRosterPush) {
        ArrayList<Contact> addedContacts = new ArrayList<Contact>();
        ArrayList<Contact> updatedContacts = new ArrayList<Contact>();
        ArrayList<Contact> removedContacts = new ArrayList<Contact>();
        ArrayList contacts = new ArrayList(roster.getContacts());
        contacts.sort(null);
        RosterManager rosterManager = this;
        synchronized (rosterManager) {
            if (!isRosterPush) {
                this.rosterGroupMap.clear();
                this.contactMap.clear();
            }
            for (Contact contact : contacts) {
                Contact oldContact = this.contactMap.get(contact.getJid());
                if (contact.getSubscription() == SubscriptionState.Subscription.REMOVE) {
                    this.contactMap.remove(contact.getJid());
                    removedContacts.add(contact);
                } else if (oldContact != null && !oldContact.equals((Object)contact)) {
                    this.contactMap.put(contact.getJid(), contact);
                    updatedContacts.add(contact);
                } else if (oldContact == null) {
                    this.contactMap.put(contact.getJid(), contact);
                    addedContacts.add(contact);
                }
                if (contact.getSubscription() != SubscriptionState.Subscription.REMOVE) {
                    for (String group : contact.getGroups()) {
                        String[] nestedGroups = this.groupDelimiter != null && !this.groupDelimiter.isEmpty() ? group.split(this.groupDelimiter, 255) : new String[]{group};
                        StringBuilder currentGroupName = new StringBuilder();
                        ContactGroup currentGroup = null;
                        for (int i = 0; i < nestedGroups.length; ++i) {
                            String nestedGroupName = nestedGroups[i];
                            currentGroupName.append(nestedGroupName);
                            ContactGroup nestedGroup = this.rosterGroupMap.get(currentGroupName.toString());
                            if (nestedGroup == null) {
                                nestedGroup = new ContactGroup(nestedGroupName, currentGroupName.toString(), currentGroup);
                                this.rosterGroupMap.put(currentGroupName.toString(), nestedGroup);
                                if (i == 0) {
                                    this.groups.add(nestedGroup);
                                }
                                if (currentGroup != null) {
                                    currentGroup.getGroups().add(nestedGroup);
                                }
                            }
                            currentGroup = nestedGroup;
                            if (i >= nestedGroups.length - 1) continue;
                            currentGroupName.append(this.groupDelimiter);
                        }
                        if (currentGroup == null) continue;
                        RosterManager.removeContactByJid(contact, currentGroup.getContacts());
                        currentGroup.getContacts().add(contact);
                    }
                }
                RosterManager.removeContactByJid(contact, this.unaffiliatedContacts);
                if (contact.getGroups().isEmpty() && contact.getSubscription() != SubscriptionState.Subscription.REMOVE) {
                    this.unaffiliatedContacts.add(contact);
                }
                this.removeContactsFromGroups(contact, this.groups);
            }
            this.cacheRoster(roster.getVersion());
        }
        XmppUtils.notifyEventListeners(this.rosterListeners, (EventObject)new RosterEvent(this, addedContacts, updatedContacts, removedContacts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheRoster(String version) {
        if (this.rosterCacheDirectory != null && version != null) {
            Roster roster = new Roster(this.contactMap.values(), version);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(outputStream, StandardCharsets.UTF_8.name()));
                    this.xmppSession.createMarshaller().marshal((Object)roster, xmppStreamWriter);
                    xmppStreamWriter.flush();
                }
                this.rosterCacheDirectory.put(XmppUtils.hash((byte[])this.xmppSession.getConnectedResource().asBareJid().toString().getBytes(StandardCharsets.UTF_8)) + ".xml", outputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not write roster to cache.", e);
            }
        }
    }

    private Roster readRosterFromCache() {
        block8: {
            if (this.rosterCacheDirectory != null) {
                Roster roster;
                byte[] rosterData = this.rosterCacheDirectory.get(XmppUtils.hash((byte[])this.xmppSession.getConnectedResource().asBareJid().toString().getBytes(StandardCharsets.UTF_8)) + ".xml");
                if (rosterData == null) break block8;
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(rosterData), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    roster = (Roster)this.xmppSession.createUnmarshaller().unmarshal((Reader)reader);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            RosterManager.$closeResource(throwable, reader);
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Could not read roster from cache.", e);
                    }
                }
                RosterManager.$closeResource(throwable, reader);
                return roster;
            }
        }
        return null;
    }

    private static void removeContactByJid(Contact contact, Collection<Contact> contacts) {
        for (Contact c : contacts) {
            if (!c.getJid().equals(contact.getJid())) continue;
            contacts.remove(c);
            break;
        }
    }

    private void removeContactsFromGroups(Contact contact, Collection<ContactGroup> contactGroups) {
        ArrayDeque emptyGroups = new ArrayDeque();
        contactGroups.stream().filter(group -> this.removeRecursively(contact, (ContactGroup)group)).forEach(group -> {
            emptyGroups.add(group);
            this.rosterGroupMap.remove(group.getFullName());
        });
        contactGroups.removeAll(emptyGroups);
    }

    private boolean removeRecursively(Contact contact, ContactGroup contactGroup) {
        this.removeContactsFromGroups(contact, contactGroup.getGroups());
        boolean contactExistsInGroup = false;
        block0: for (Contact c : contactGroup.getContacts()) {
            if (!c.getJid().equals(contact.getJid())) continue;
            for (String groupName : contact.getGroups()) {
                if (!groupName.equals(contactGroup.getFullName())) continue;
                contactExistsInGroup = true;
                break block0;
            }
        }
        if (!contactExistsInGroup || contact.getSubscription() == SubscriptionState.Subscription.REMOVE) {
            RosterManager.removeContactByJid(contact, contactGroup.getContacts());
        }
        return contactGroup.getContacts().isEmpty() && contactGroup.getGroups().isEmpty();
    }

    public final synchronized Collection<ContactGroup> getContactGroups() {
        return Collections.unmodifiableCollection((TreeSet)this.groups.clone());
    }

    public final synchronized Collection<Contact> getUnaffiliatedContacts() {
        return Collections.unmodifiableCollection((TreeSet)this.unaffiliatedContacts.clone());
    }

    public final void addRosterListener(Consumer<RosterEvent> rosterListener) {
        this.rosterListeners.add(rosterListener);
    }

    public final void removeRosterListener(Consumer<RosterEvent> rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public final synchronized boolean isRetrieveRosterOnLogin() {
        return this.retrieveRosterOnLogin;
    }

    public final synchronized void setRetrieveRosterOnLogin(boolean retrieveRosterOnLogin) {
        this.retrieveRosterOnLogin = retrieveRosterOnLogin;
    }

    public final AsyncResult<Roster> requestRoster() {
        AsyncResult rosterDelimiterQuery;
        if (this.isAskForGroupDelimiter()) {
            PrivateDataManager privateDataManager = this.xmppSession.getManager(PrivateDataManager.class);
            AsyncResult<RosterDelimiter> query = privateDataManager.getData(RosterDelimiter.class);
            rosterDelimiterQuery = query.exceptionally(e -> {
                if (e != null) {
                    logger.log(Level.WARNING, "Roster delimiter could not be retrieved from private storage.", (Throwable)e);
                }
                return null;
            }).thenAccept(rosterDelimiter -> this.setGroupDelimiter(rosterDelimiter != null ? rosterDelimiter.getRosterDelimiter() : null));
        } else {
            rosterDelimiterQuery = new AsyncResult(CompletableFuture.completedFuture(null));
        }
        return rosterDelimiterQuery.thenCompose(result -> {
            Roster rosterRequest;
            Roster cachedRoster = null;
            if (this.isRosterVersioningSupported()) {
                cachedRoster = this.readRosterFromCache();
                String ver = cachedRoster != null ? cachedRoster.getVersion() : "";
                rosterRequest = new Roster(ver);
            } else {
                rosterRequest = new Roster();
            }
            Roster tempRoster = cachedRoster;
            return this.xmppSession.query(IQ.get((Object)rosterRequest)).thenApply(iq -> {
                Roster rosterResult = (Roster)iq.getExtension(Roster.class);
                Roster currentRoster = rosterResult != null ? rosterResult : tempRoster;
                this.updateRoster(currentRoster, false);
                return currentRoster;
            });
        });
    }

    public final AsyncResult<Void> addContact(Contact contact, boolean requestSubscription, String status) {
        Objects.requireNonNull(contact, "contact must not be null.");
        AsyncResult<IQ> query = this.xmppSession.query(IQ.set((Object)new Roster(new Contact[]{contact})));
        return query.thenRun(() -> {
            if (requestSubscription) {
                this.xmppSession.getManager(PresenceManager.class).requestSubscription(contact.getJid(), status);
            }
        });
    }

    public final AsyncResult<Void> updateContact(Contact contact) {
        return this.addContact(contact, false, null);
    }

    public final AsyncResult<Void> removeContact(Jid jid) {
        Roster roster = new Roster(new Contact[]{Contact.removeContact((Jid)jid)});
        return this.xmppSession.query(IQ.set((Object)roster), Void.class);
    }

    public final AsyncResult<Void> renameContactGroup(ContactGroup contactGroup, String name) {
        int depth = -1;
        ContactGroup parentGroup = contactGroup;
        do {
            parentGroup = parentGroup.getParentGroup();
            ++depth;
        } while (parentGroup != null);
        return this.replaceGroupName(contactGroup, name, depth);
    }

    private synchronized AsyncResult<Void> replaceGroupName(ContactGroup contactGroup, String name, int index) {
        String newName = name;
        if (this.groupDelimiter != null && !this.groupDelimiter.isEmpty()) {
            String[] groups = contactGroup.getFullName().split(this.groupDelimiter, 255);
            if (index < groups.length) {
                groups[index] = name;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < groups.length - 1; ++i) {
                sb.append(groups[i]).append(this.groupDelimiter);
            }
            sb.append(groups[groups.length - 1]);
            newName = sb.toString();
        }
        ArrayList<AsyncResult<Void>> completionStages = new ArrayList<AsyncResult<Void>>();
        for (Contact contact : contactGroup.getContacts()) {
            ArrayList<String> newGroups = new ArrayList<String>(contact.getGroups());
            newGroups.remove(contactGroup.getFullName());
            newGroups.add(newName);
            if (contact.getGroups().equals(newGroups)) continue;
            completionStages.add(this.updateContact(contact.withGroups(newGroups)));
        }
        completionStages.addAll(contactGroup.getGroups().stream().map(subGroup -> this.replaceGroupName((ContactGroup)subGroup, name, index)).collect(Collectors.toList()));
        return new AsyncResult(CompletableFuture.allOf((CompletableFuture[])completionStages.stream().map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)));
    }

    public final AsyncResult<Void> removeContactGroup(ContactGroup contactGroup) {
        Collection<Contact> allContacts = RosterManager.collectAllContactsInGroup(contactGroup);
        CompletableFuture[] completableFutures = contactGroup.getParentGroup() != null ? (CompletableFuture[])allContacts.stream().map(contact -> this.updateContact(contact.withGroups(new String[]{contactGroup.getParentGroup().getFullName()})).thenRun(() -> {}).toCompletableFuture()).toArray(CompletableFuture[]::new) : (CompletableFuture[])allContacts.stream().map(contact -> this.updateContact(contact.withoutGroups()).thenRun(() -> {}).toCompletableFuture()).toArray(CompletableFuture[]::new);
        return new AsyncResult(CompletableFuture.allOf(completableFutures));
    }

    public final synchronized String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public final synchronized void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public final AsyncResult<Void> storeGroupDelimiter(String groupDelimiter) {
        return this.privateDataManager.storeData(RosterDelimiter.of((String)groupDelimiter)).thenAccept(result -> this.setGroupDelimiter(groupDelimiter));
    }

    public synchronized boolean isAskForGroupDelimiter() {
        return this.askForGroupDelimiter;
    }

    public synchronized void setAskForGroupDelimiter(boolean askForGroupDelimiter) {
        this.askForGroupDelimiter = askForGroupDelimiter;
    }

    public boolean isRosterVersioningSupported() {
        return this.xmppSession.getManager(StreamFeaturesManager.class).getFeatures().containsKey(RosterVersioning.class);
    }

    @Override
    protected void dispose() {
        this.rosterListeners.clear();
    }
}

