/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.util.concurrent.CompletionStages;

public abstract class AbstractConnection
implements Connection {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CompletableFuture<Void> closedByPeer = new CompletableFuture();
    private final ConnectionConfiguration connectionConfiguration;
    private String streamId;

    protected AbstractConnection(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    @Override
    public final ConnectionConfiguration getConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    public boolean isUsingAcknowledgements() {
        return false;
    }

    protected abstract void restartStream();

    protected abstract CompletionStage<Void> closeStream();

    protected abstract CompletionStage<Void> closeConnection();

    protected final synchronized void openedByPeer(SessionOpen sessionOpen) {
        this.streamId = sessionOpen.getId();
    }

    protected void closedByPeer() {
        this.closedByPeer.complete(null);
        this.closeAsync();
    }

    @Override
    public final synchronized String getStreamId() {
        return this.streamId;
    }

    @Override
    public final CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            return this.closeStream().thenCompose(v -> this.closedByPeer.applyToEither(CompletionStages.timeoutAfter(500L, TimeUnit.MILLISECONDS), Function.identity())).handle((aVoid, exc) -> this.closeConnection()).thenCompose(Function.identity());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public final CompletionStage<Void> closeAsync(StreamError streamError) {
        this.write(streamError);
        return this.closeAsync();
    }

    @Override
    public final void close() throws Exception {
        try {
            this.closeAsync().toCompletableFuture().get(2L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }
}

