/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.hashes.model.Hashed;
import rocks.xmpp.util.Strings;

@XmlRootElement(name="c")
public final class EntityCapabilities1
extends StreamFeature
implements EntityCapabilities,
Hashed {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    @XmlAttribute
    private final String hash;
    @XmlAttribute
    private final String node;
    @XmlAttribute
    private final byte[] ver;

    private EntityCapabilities1() {
        this.node = null;
        this.hash = null;
        this.ver = null;
    }

    public EntityCapabilities1(String node, InfoNode infoNode, MessageDigest messageDigest) {
        this.node = Objects.requireNonNull(node);
        this.hash = messageDigest.getAlgorithm();
        this.ver = messageDigest.digest(this.createVerificationString(infoNode));
    }

    @Override
    public final String getHashAlgorithm() {
        return this.hash;
    }

    @Override
    public final byte[] getHashValue() {
        return (byte[])this.ver.clone();
    }

    public final String getNode() {
        return this.node;
    }

    public final String getVerificationString() {
        return Base64.getEncoder().encodeToString(this.ver);
    }

    @Override
    public final Set<Hashed> getCapabilityHashSet() {
        return Collections.singleton(this);
    }

    @Override
    public final byte[] createVerificationString(InfoNode infoNode) {
        Set<Identity> identities = infoNode.getIdentities();
        Set<String> features = infoNode.getFeatures();
        ArrayList<DataForm> dataForms = new ArrayList<DataForm>(infoNode.getExtensions());
        StringBuilder sb = new StringBuilder();
        for (Identity identity : identities) {
            if (identity.getCategory() != null) {
                sb.append(identity.getCategory());
            }
            sb.append('/');
            if (identity.getType() != null) {
                sb.append(identity.getType());
            }
            sb.append('/');
            if (identity.getLanguage() != null) {
                sb.append(identity.getLanguage());
            }
            sb.append('/');
            if (identity.getName() != null) {
                sb.append(identity.getName());
            }
            sb.append('<');
        }
        for (String feature : features) {
            if (feature != null) {
                sb.append(feature);
            }
            sb.append('<');
        }
        dataForms.sort(null);
        for (DataForm dataForm : dataForms) {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>(dataForm.getFields());
            fields.sort(null);
            if (fields.isEmpty() || !"FORM_TYPE".equals(((DataForm.Field)fields.get(0)).getVar()) || ((DataForm.Field)fields.get(0)).getType() != DataForm.Field.Type.HIDDEN) continue;
            for (DataForm.Field field : fields) {
                ArrayList<String> values = new ArrayList<String>(field.getValues());
                if (!"FORM_TYPE".equals(field.getVar())) {
                    sb.append(field.getVar()).append('<');
                    values.sort((s, t1) -> Strings.compareUnsignedBytes(s, t1, StandardCharsets.UTF_8));
                }
                for (String value : values) {
                    sb.append(value).append('<');
                }
            }
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public final String createCapabilityHashNode(Hashed hashed) {
        return this.node + '#' + Base64.getEncoder().encodeToString(hashed.getHashValue());
    }

    public final String toString() {
        return "Caps: " + this.getVerificationString();
    }
}

