/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind.model;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.model.SessionOpen;

@XmlRootElement
public final class Body
implements SessionOpen,
Comparable<Body> {
    public static final String NAMESPACE = "http://jabber.org/protocol/httpbind";
    public static final String XBOSH_NAMESPACE = "urn:xmpp:xbosh";
    @XmlAnyElement(lax=true)
    private final List<Object> wrappedObjects = new ArrayList<Object>();
    private final URI uri;
    @XmlAttribute
    private final String accept;
    @XmlAttribute
    private final Long ack;
    @XmlAttribute(name="authid")
    private final String authId;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CharsetAdapter.class)
    private final List<Charset> charsets;
    @XmlAttribute
    private final Condition condition;
    @XmlAttribute
    private final String content;
    @XmlAttribute
    private final Jid from;
    @XmlAttribute
    private final Short hold;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration inactivity;
    @XmlAttribute
    private final String key;
    @XmlAttribute(name="maxpause")
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration maxPause;
    @XmlAttribute(name="newkey")
    private final String newKey;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration pause;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration polling;
    @XmlAttribute
    private final Long report;
    @XmlAttribute
    private final Short requests;
    @XmlAttribute
    private final Long rid;
    @XmlAttribute
    private final String route;
    @XmlAttribute
    private final String sid;
    @XmlAttribute
    private final String stream;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=MillisecondsAdapter.class)
    private final Duration time;
    @XmlAttribute
    private final Jid to;
    @XmlAttribute
    private final Type type;
    @XmlAttribute
    private final String ver;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration wait;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final String version;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final Boolean restartlogic;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final Boolean restart;

    private Body() {
        this.uri = null;
        this.accept = null;
        this.ack = null;
        this.authId = null;
        this.charsets = null;
        this.condition = null;
        this.content = null;
        this.from = null;
        this.hold = null;
        this.inactivity = null;
        this.key = null;
        this.maxPause = null;
        this.newKey = null;
        this.pause = null;
        this.polling = null;
        this.report = null;
        this.requests = null;
        this.rid = null;
        this.route = null;
        this.sid = null;
        this.stream = null;
        this.time = null;
        this.to = null;
        this.type = null;
        this.ver = null;
        this.wait = null;
        this.lang = null;
        this.restart = null;
        this.restartlogic = null;
        this.version = null;
    }

    private Body(Builder builder) {
        this.uri = builder.uri;
        this.accept = builder.accept;
        this.ack = builder.ack;
        this.authId = builder.authId;
        this.charsets = builder.charsets != null ? Arrays.asList(builder.charsets) : null;
        this.condition = builder.condition;
        this.content = builder.content;
        this.from = builder.from;
        this.hold = builder.hold;
        this.inactivity = builder.inactivity;
        this.key = builder.key;
        this.maxPause = builder.maxPause;
        this.newKey = builder.newKey;
        this.pause = builder.pause;
        this.polling = builder.polling;
        this.report = builder.report;
        this.requests = builder.requests;
        this.rid = builder.requestId;
        this.route = builder.route;
        this.sid = builder.sessionId;
        this.stream = builder.stream;
        this.time = builder.time;
        this.to = builder.to;
        this.type = builder.type;
        this.ver = builder.version;
        this.wait = builder.wait;
        this.lang = builder.language;
        this.restart = builder.restart;
        this.restartlogic = builder.restartlogic;
        this.version = builder.xmppVersion;
        this.wrappedObjects.addAll(builder.wrappedObjects);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final List<Object> getWrappedObjects() {
        return Collections.unmodifiableList(this.wrappedObjects);
    }

    public final URI getUri() {
        return this.uri;
    }

    public final String getAccept() {
        return this.accept;
    }

    public final Long getAck() {
        return this.ack;
    }

    public final String getAuthId() {
        return this.authId;
    }

    public final List<Charset> getCharsets() {
        return this.charsets != null ? this.charsets : Collections.emptyList();
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String getContent() {
        return this.content;
    }

    @Override
    public final Jid getFrom() {
        return this.from;
    }

    public final Short getHold() {
        return this.hold;
    }

    public final Duration getInactivity() {
        return this.inactivity;
    }

    public final String getKey() {
        return this.key;
    }

    public final Duration getMaxPause() {
        return this.maxPause;
    }

    public final String getNewKey() {
        return this.newKey;
    }

    public final Duration getPause() {
        return this.pause;
    }

    public final Duration getPolling() {
        return this.polling;
    }

    public final Long getReport() {
        return this.report;
    }

    public final Short getRequests() {
        return this.requests;
    }

    public final Long getRid() {
        return this.rid;
    }

    public final String getRoute() {
        return this.route;
    }

    public final String getSid() {
        return this.sid;
    }

    @Override
    public final String getId() {
        return this.sid;
    }

    public final String getStream() {
        return this.stream;
    }

    public final Duration getTime() {
        return this.time;
    }

    @Override
    public final Jid getTo() {
        return this.to;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getBoshVersion() {
        return this.ver;
    }

    public final Duration getWait() {
        return this.wait;
    }

    @Override
    public final Locale getLanguage() {
        return this.lang;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    public final boolean isRestart() {
        return this.restart != null && this.restart != false;
    }

    public final boolean isRestartLogic() {
        return this.restartlogic != null && this.restartlogic != false;
    }

    @Override
    public final int compareTo(Body o) {
        if (o == null) {
            return -1;
        }
        if (this.rid != null) {
            if (o.rid != null) {
                return this.rid.compareTo(o.rid);
            }
            return 1;
        }
        if (o.rid != null) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.rid != null) {
            sb.append("RID: ").append(this.rid).append("; ");
        }
        if (this.sid != null) {
            sb.append("SID: ").append(this.sid).append("; ");
        }
        if (this.wait != null) {
            sb.append("Wait: ").append(this.wait);
        }
        return sb.toString();
    }

    private static final class MillisecondsAdapter
    extends XmlAdapter<Integer, Duration> {
        private MillisecondsAdapter() {
        }

        public final Duration unmarshal(Integer v) {
            if (v != null) {
                return Duration.ofMillis(v.intValue());
            }
            return null;
        }

        public final Integer marshal(Duration v) {
            if (v != null) {
                return (int)Math.min(v.toMillis(), Integer.MAX_VALUE);
            }
            return null;
        }
    }

    private static final class SecondsAdapter
    extends XmlAdapter<Integer, Duration> {
        private SecondsAdapter() {
        }

        public final Duration unmarshal(Integer v) {
            if (v != null) {
                return Duration.ofSeconds(v.intValue());
            }
            return null;
        }

        public final Integer marshal(Duration v) {
            if (v != null) {
                return (int)Math.min(v.getSeconds(), Integer.MAX_VALUE);
            }
            return null;
        }
    }

    private static final class CharsetAdapter
    extends XmlAdapter<String, List<Charset>> {
        private CharsetAdapter() {
        }

        public final List<Charset> unmarshal(String charsets) {
            if (charsets != null) {
                return Collections.unmodifiableList(Arrays.stream(charsets.split(" ")).map(Charset::forName).collect(Collectors.toList()));
            }
            return null;
        }

        public final String marshal(List<Charset> charsets) {
            if (charsets != null && !charsets.isEmpty()) {
                return String.join((CharSequence)" ", charsets.stream().map(c -> c.name())::iterator);
            }
            return null;
        }
    }

    public static final class Builder {
        private URI uri;
        private final List<Object> wrappedObjects = new ArrayList<Object>();
        private String accept;
        private Long ack;
        private String authId;
        private Charset[] charsets;
        private Condition condition;
        private String content;
        private Jid from;
        private Short hold;
        private Duration inactivity;
        private String key;
        private Duration maxPause;
        private String newKey;
        private Duration pause;
        private Duration polling;
        private Long report;
        private Short requests;
        private Long requestId;
        private String route;
        private String sessionId;
        private String stream;
        private Duration time;
        private Jid to;
        private Type type;
        private String version;
        private Duration wait;
        private Locale language;
        private String xmppVersion;
        private Boolean restart;
        private Boolean restartlogic;

        private Builder() {
        }

        public final Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final Builder ack(long ack) {
            this.ack = ack;
            return this;
        }

        public final Builder authId(String authId) {
            this.authId = authId;
            return this;
        }

        public final Builder charsets(Charset ... charsets) {
            this.charsets = charsets;
            return this;
        }

        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Builder from(Jid from) {
            this.from = from;
            return this;
        }

        public final Builder hold(short hold) {
            this.hold = hold;
            return this;
        }

        public final Builder inactivity(Duration inactivity) {
            this.inactivity = inactivity;
            return this;
        }

        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Builder maxPause(Duration maxPause) {
            this.maxPause = maxPause;
            return this;
        }

        public final Builder newKey(String newKey) {
            this.newKey = newKey;
            return this;
        }

        public final Builder pause(Duration pause) {
            this.pause = pause;
            return this;
        }

        public final Builder polling(Duration polling) {
            this.polling = polling;
            return this;
        }

        public final Builder report(long report) {
            this.report = report;
            return this;
        }

        public final Builder requests(short requests) {
            this.requests = requests;
            return this;
        }

        public final Builder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Builder route(String route) {
            this.route = route;
            return this;
        }

        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Builder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public final Builder time(Duration time) {
            this.time = time;
            return this;
        }

        public final Builder to(Jid to) {
            this.to = to;
            return this;
        }

        public final Builder type(Type type) {
            this.type = type;
            return this;
        }

        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Builder wait(Duration wait) {
            this.wait = wait;
            return this;
        }

        public final Builder language(Locale language) {
            this.language = language;
            return this;
        }

        public final Builder xmppVersion(String xmppVersion) {
            this.xmppVersion = xmppVersion;
            return this;
        }

        public final Builder restart(boolean restart) {
            this.restart = restart;
            return this;
        }

        public final Builder restartLogic(boolean restartlogic) {
            this.restartlogic = restartlogic;
            return this;
        }

        public final Builder wrappedObjects(Collection<Object> objects) {
            this.wrappedObjects.clear();
            this.wrappedObjects.addAll(objects);
            return this;
        }

        public final Body build() {
            return new Body(this);
        }
    }

    @XmlEnum
    public static enum Type {
        ERROR,
        TERMINATE;

    }

    @XmlEnum
    public static enum Condition {
        BAD_REQUEST,
        HOST_GONE,
        HOST_UNKNOWN,
        IMPROPER_ADDRESSING,
        INTERNAL_SERVER_ERROR,
        ITEM_NOT_FOUND,
        OTHER_REQUEST,
        POLICY_VIOLATION,
        REMOTE_CONNECTION_FAILED,
        REMOTE_STREAM_ERROR,
        SEE_OTHER_URI,
        SYSTEM_SHUTDOWN,
        UNDEFINED_CONDITION;


        public String toString() {
            return this.name().toLowerCase().replace("_", "-");
        }
    }
}

