/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.roster.model;

import java.text.Collator;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import rocks.xmpp.im.roster.model.Contact;

public final class ContactGroup
implements Comparable<ContactGroup> {
    private final Set<Contact> contacts;
    private final Set<ContactGroup> groups;
    private final ContactGroup parentGroup;
    private final String name;
    private final String fullName;

    public ContactGroup(String name, String fullName, ContactGroup parentGroup) {
        this.name = name;
        this.fullName = fullName;
        this.contacts = new TreeSet<Contact>();
        this.groups = new TreeSet<ContactGroup>();
        this.parentGroup = parentGroup;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final Collection<ContactGroup> getGroups() {
        return this.groups;
    }

    public final Collection<Contact> getContacts() {
        return this.contacts;
    }

    public final ContactGroup getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public final int compareTo(ContactGroup o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            if (this.fullName != null) {
                if (o.fullName != null) {
                    return Collator.getInstance().compare(this.fullName, o.fullName);
                }
                return -1;
            }
            if (o.fullName != null) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactGroup)) {
            return false;
        }
        ContactGroup other = (ContactGroup)o;
        return Objects.equals(this.fullName, other.fullName);
    }

    public final int hashCode() {
        return Objects.hash(this.fullName);
    }

    public final String toString() {
        return this.name;
    }
}

