/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class PrefixFreeCanonicalizationWriter
implements XMLStreamWriter,
NamespaceContext {
    private static final Collection<String> PREFIXED_NAMESPACES = Arrays.asList("http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope");
    private final XMLStreamWriter xsw;
    private final boolean writeStreamNamespace;
    private final Map<String, String> urisByPrefix = new HashMap<String, String>();

    PrefixFreeCanonicalizationWriter(XMLStreamWriter xsw, boolean writeStreamNamespace) {
        this.xsw = xsw;
        this.writeStreamNamespace = writeStreamNamespace;
    }

    @Override
    public final void writeStartElement(String localName) throws XMLStreamException {
        this.xsw.writeStartElement(localName);
    }

    @Override
    public final void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xsw.writeStartElement(namespaceURI, localName);
    }

    @Override
    public final void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeElement(prefix, localName, namespaceURI, this.xsw::writeStartElement);
    }

    @Override
    public final void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xsw.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public final void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeElement(prefix, localName, namespaceURI, this.xsw::writeEmptyElement);
    }

    private void writeElement(String prefix, String localName, String namespaceURI, ElementWriter writeElement) throws XMLStreamException {
        if (this.shouldWriteNamespacePrefix(namespaceURI)) {
            writeElement.writeElement(prefix, localName, namespaceURI);
        } else {
            String namespaceUriInScope = this.getNamespaceContext().getNamespaceURI("");
            writeElement.writeElement("", localName, namespaceURI);
            if (!(namespaceUriInScope != null && Objects.equals(namespaceUriInScope, namespaceURI) || "".equals(namespaceURI))) {
                this.xsw.writeDefaultNamespace(namespaceURI);
            }
        }
    }

    @Override
    public final void writeEmptyElement(String localName) throws XMLStreamException {
        this.xsw.writeEmptyElement(localName);
    }

    @Override
    public final void writeEndElement() throws XMLStreamException {
        this.xsw.writeEndElement();
    }

    @Override
    public final void writeEndDocument() throws XMLStreamException {
        this.xsw.writeEndDocument();
    }

    @Override
    public final void close() throws XMLStreamException {
        this.xsw.close();
    }

    @Override
    public final void flush() throws XMLStreamException {
        this.xsw.flush();
    }

    @Override
    public final void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(localName, value);
    }

    @Override
    public final void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        String[] split;
        if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && this.getNamespaceContext().getPrefix(namespaceURI) == null) {
            this.xsw.writeNamespace(prefix, namespaceURI);
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) && "type".equals(localName) && (split = value.split(":", 2)).length > 1) {
            String typePrefix = split[0];
            String namespaceUri = this.getNamespaceURI(typePrefix);
            String pref = this.xsw.getPrefix(namespaceUri);
            if (!"".equals(pref) && !"".equals(namespaceUri) && namespaceUri != null) {
                this.xsw.writeNamespace(typePrefix, namespaceUri);
            } else {
                value = split[1];
            }
        }
        this.xsw.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public final void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public final void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.shouldWriteNamespace(namespaceURI)) {
            this.xsw.writeNamespace(prefix, namespaceURI);
        } else {
            this.urisByPrefix.put(prefix, namespaceURI);
        }
    }

    @Override
    public final void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xsw.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public final void writeComment(String data) throws XMLStreamException {
        this.xsw.writeComment(data);
    }

    @Override
    public final void writeProcessingInstruction(String target) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target);
    }

    @Override
    public final void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target, data);
    }

    @Override
    public final void writeCData(String data) throws XMLStreamException {
        this.xsw.writeCData(data);
    }

    @Override
    public final void writeDTD(String dtd) throws XMLStreamException {
        this.xsw.writeDTD(dtd);
    }

    @Override
    public final void writeEntityRef(String name) throws XMLStreamException {
        this.xsw.writeEntityRef(name);
    }

    @Override
    public final void writeStartDocument() throws XMLStreamException {
        this.xsw.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.xsw.writeStartDocument(version);
    }

    @Override
    public final void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.xsw.writeStartDocument(encoding, version);
    }

    @Override
    public final void writeCharacters(String text) throws XMLStreamException {
        this.xsw.writeCharacters(text);
    }

    @Override
    public final void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.xsw.writeCharacters(text, start, len);
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        String uri = this.getNamespaceContext().getNamespaceURI(prefix);
        if ((uri == null || "".equals(uri)) && (uri = this.urisByPrefix.get(prefix)) == null) {
            return "";
        }
        return uri;
    }

    @Override
    public final String getPrefix(String uri) {
        return this.getNamespaceContext().getPrefix(uri);
    }

    public final Iterator getPrefixes(String namespaceURI) {
        return this.getNamespaceContext().getPrefixes(namespaceURI);
    }

    @Override
    public final void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.xsw.setPrefix(prefix, uri);
    }

    @Override
    public final void setDefaultNamespace(String uri) throws XMLStreamException {
        this.xsw.setDefaultNamespace(uri);
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this.xsw.getNamespaceContext();
    }

    @Override
    public final void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.xsw.setNamespaceContext(context);
    }

    @Override
    public final Object getProperty(String name) throws IllegalArgumentException {
        return this.xsw.getProperty(name);
    }

    private boolean shouldWriteNamespace(String namespaceURI) {
        return PREFIXED_NAMESPACES.stream().anyMatch(namespace -> this.getNamespaceContext().getPrefix((String)namespace) != null || namespaceURI.equals(namespace)) || "http://etherx.jabber.org/streams".equals(namespaceURI) && this.writeStreamNamespace;
    }

    private boolean shouldWriteNamespacePrefix(String namespaceURI) {
        return this.shouldWriteNamespace(namespaceURI) || "http://etherx.jabber.org/streams".equals(namespaceURI);
    }

    private static interface ElementWriter {
        public void writeElement(String var1, String var2, String var3) throws XMLStreamException;
    }
}

