/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.nio.charset.Charset;
import java.util.regex.Pattern;

public final class Strings {
    private static final Pattern CAMEL_CASE = Pattern.compile("(\\p{Ll})(\\p{Lu}+)");

    private Strings() {
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String toDash(String str) {
        if (str == null) {
            return null;
        }
        return CAMEL_CASE.matcher(str).replaceAll("$1-$2").toLowerCase();
    }

    public static String toUnderscore(String str) {
        if (str == null) {
            return null;
        }
        return CAMEL_CASE.matcher(str).replaceAll("$1_$2").toLowerCase();
    }

    public static int compareUnsignedBytes(String s1, String s2, Charset charset) {
        byte[] o1 = s1.getBytes(charset);
        byte[] o2 = s2.getBytes(charset);
        int length = Math.min(o1.length, o2.length);
        for (int i = 0; i < length; ++i) {
            int a = o1[i] & 0xFF;
            int b = o2[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return o1.length - o2.length;
    }
}

