/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import rocks.xmpp.util.XmppUtils;

public final class CompletionStages {
    private static final ScheduledExecutorService TIMEOUT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory("timeout-scheduler"));

    private CompletionStages() {
    }

    public static <T> CompletionStage<T> withFallback(CompletionStage<T> stage, BiFunction<CompletionStage<T>, Throwable, ? extends CompletionStage<T>> fallback) {
        return stage.handle((response, error) -> error).thenCompose(error -> error != null ? (CompletionStage)fallback.apply(stage, (Throwable)error) : stage);
    }

    public static <T> CompletionStage<List<T>> allOf(Collection<? extends CompletionStage<List<T>>> stages) {
        return CompletableFuture.allOf(stages.stream().map(CompletionStage::toCompletableFuture).collect(Collectors.toList()).toArray(new CompletableFuture[stages.size()])).thenApply(result -> stages.stream().map(stage -> (List)stage.toCompletableFuture().join()).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public static <T> CompletionStage<T> timeoutAfter(long delay, TimeUnit unit) {
        return CompletionStages.timeoutAfter(delay, unit, () -> new TimeoutException("Timeout after " + delay + ' ' + (Object)((Object)unit)));
    }

    public static <T> CompletionStage<T> timeoutAfter(long delay, TimeUnit unit, Supplier<Throwable> throwableSupplier) {
        CompletableFuture completableFuture = new CompletableFuture();
        TIMEOUT_EXECUTOR.schedule(() -> completableFuture.completeExceptionally((Throwable)throwableSupplier.get()), delay, unit);
        return completableFuture;
    }
}

