/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueuedExecutorService
extends AbstractExecutorService {
    private final ExecutorService delegate;
    final AtomicBoolean lock;
    private final AtomicBoolean shutdown;
    private final BlockingQueue<Runnable> tasks;

    public QueuedExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
        this.lock = new AtomicBoolean(false);
        this.shutdown = new AtomicBoolean(false);
        this.tasks = new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AtomicBoolean atomicBoolean = this.shutdown;
        synchronized (atomicBoolean) {
            this.shutdown.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        AtomicBoolean atomicBoolean = this.shutdown;
        synchronized (atomicBoolean) {
            this.shutdown();
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            this.tasks.drainTo(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        AtomicBoolean atomicBoolean = this.shutdown;
        synchronized (atomicBoolean) {
            return this.shutdown.get();
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.tasks.isEmpty() && !this.lock.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long now = System.nanoTime();
                TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                nanos -= System.nanoTime() - now;
            }
        }
    }

    void execute(Runnable command, boolean ignoreShutdown) {
        if (ignoreShutdown || !this.isShutdown()) {
            this.tasks.add(command);
            this.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        if (!this.tasks.isEmpty() && !this.lock.getAndSet(true)) {
            Runnable task = (Runnable)this.tasks.poll();
            if (task != null) {
                this.delegate.execute(() -> this.doExecute(task));
            } else {
                this.lock.set(false);
                this.poll();
            }
        } else if (this.tasks.isEmpty()) {
            AtomicBoolean atomicBoolean = this.lock;
            synchronized (atomicBoolean) {
                this.lock.notifyAll();
            }
        }
    }

    private void doExecute(Runnable task) {
        try {
            task.run();
        }
        finally {
            this.lock.set(false);
            this.poll();
        }
    }
}

