/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.Future;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbInputStream;
import rocks.xmpp.extensions.bytestreams.ibb.IbbOutputStream;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;
import rocks.xmpp.util.concurrent.AsyncResult;

final class IbbSession
extends ByteStreamSession {
    private final IbbOutputStream outputStream;
    private final IbbInputStream inputStream;
    private final Jid jid;
    private final int blockSize;
    private final XmppSession xmppSession;
    private final InBandByteStreamManager inBandByteStreamManager;
    private final InBandByteStream.Open.StanzaType stanzaType;
    private int inboundSequence = 0;
    private int outboundSequence = 0;
    private boolean closed;

    IbbSession(String sessionId, XmppSession xmppSession, Jid jid, int blockSize, Duration readTimeout, InBandByteStreamManager manager, InBandByteStream.Open.StanzaType stanzaType) {
        super(sessionId);
        this.outputStream = new IbbOutputStream(this, blockSize);
        this.inputStream = new IbbInputStream(this, readTimeout.toMillis());
        this.jid = jid;
        this.xmppSession = xmppSession;
        this.blockSize = blockSize;
        this.inBandByteStreamManager = manager;
        this.stanzaType = stanzaType;
    }

    final synchronized boolean dataReceived(InBandByteStream.Data data) {
        return this.inboundSequence++ == data.getSequence() && this.inputStream.queue.offer(data);
    }

    final AsyncResult<IQ> open() {
        return this.xmppSession.query(IQ.set((Jid)this.jid, (Object)new InBandByteStream.Open(this.blockSize, this.getSessionId(), this.stanzaType)));
    }

    @Override
    public final synchronized OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.outputStream;
    }

    @Override
    public final synchronized InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.inputStream;
    }

    final Future<?> send(byte[] bytes) {
        AsyncResult result;
        InBandByteStream.Data data = new InBandByteStream.Data(bytes, this.getSessionId(), this.outboundSequence);
        if (this.stanzaType == InBandByteStream.Open.StanzaType.MESSAGE) {
            Message message = new Message(this.jid);
            message.addExtension((Object)data);
            result = this.xmppSession.sendMessage(message);
        } else {
            result = this.xmppSession.query(IQ.set((Jid)this.jid, (Object)data));
        }
        if (++this.outboundSequence > 65535) {
            this.outboundSequence = 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        IbbSession ibbSession = this;
        synchronized (ibbSession) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.xmppSession.send((StreamElement)IQ.set((Jid)this.jid, (Object)new InBandByteStream.Close(this.getSessionId())));
        }
        finally {
            this.inBandByteStreamManager.ibbSessionMap.remove(this.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closedByPeer() throws IOException {
        IbbSession ibbSession = this;
        synchronized (ibbSession) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.inputStream.close();
        this.outputStream.close();
    }

    public final String toString() {
        return "In-Band Bytestream Session: " + this.getSessionId();
    }
}

