/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;

final class S5bSession
extends ByteStreamSession {
    private final Jid streamHost;
    private final Socket socket;

    S5bSession(String sessionId, Socket socket, Jid streamHost, Duration readTimeout) throws SocketException {
        super(sessionId);
        this.socket = socket;
        this.socket.setSoTimeout((int)readTimeout.toMillis());
        this.streamHost = streamHost;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public final void close() throws Exception {
        this.socket.close();
    }

    public final Jid getStreamHost() {
        return this.streamHost;
    }

    public final String toString() {
        return "SOCKS5 Bytestream Session: " + this.getSessionId();
    }
}

