/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.chatstates;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.chatstates.model.ChatState;
import rocks.xmpp.extensions.xhtmlim.model.Html;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ChatStateManager
extends Manager {
    private final Map<Chat, ChatState> chatMap = new ConcurrentHashMap<Chat, ChatState>();
    private final Map<Jid, Boolean> contactSupportsChatStateNotifications = new ConcurrentHashMap<Jid, Boolean>();
    private final Consumer<MessageEvent> messageListener = e -> {
        Message message = e.getMessage();
        if (message.getType() == Message.Type.CHAT || message.getType() == Message.Type.GROUPCHAT) {
            boolean containsChatState = message.hasExtension(ChatState.class);
            if (!e.isInbound()) {
                Boolean isSupportedByPeer;
                if (!containsChatState && (message.getBody() != null && !message.getBody().trim().equals("") || message.hasExtension(Html.class)) && ((isSupportedByPeer = this.contactSupportsChatStateNotifications.get(message.getTo())) == null || isSupportedByPeer.booleanValue())) {
                    message.putExtension((Object)ChatState.ACTIVE);
                }
            } else if (message.getType() != Message.Type.GROUPCHAT) {
                this.contactSupportsChatStateNotifications.put(message.getFrom(), containsChatState);
            }
        }
    };

    private ChatStateManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundMessageListener(this.messageListener);
        this.xmppSession.addOutboundMessageListener(this.messageListener);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundMessageListener(this.messageListener);
        this.xmppSession.removeOutboundMessageListener(this.messageListener);
    }

    public final boolean setChatState(ChatState chatState, Chat chat) {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Chat States aren't enabled. Please enable them before sending chat states.");
        }
        if (this.chatMap.put(Objects.requireNonNull(chat), Objects.requireNonNull(chatState)) == chatState) {
            return false;
        }
        Message message = new Message();
        message.putExtension((Object)chatState);
        chat.sendMessage(message);
        return true;
    }

    public final AsyncResult<Boolean> isSupported(Jid jid) {
        Boolean supports = this.contactSupportsChatStateNotifications.get(jid);
        if (supports == null) {
            return this.xmppSession.isSupported("http://jabber.org/protocol/chatstates", jid).thenApply(result -> {
                this.contactSupportsChatStateNotifications.put(jid, (Boolean)result);
                return result;
            });
        }
        return new AsyncResult(CompletableFuture.completedFuture(supports));
    }

    protected void dispose() {
        this.chatMap.clear();
        this.contactSupportsChatStateNotifications.clear();
    }
}

