/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.component.accept;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.net.client.SocketConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.component.accept.model.ComponentIQ;
import rocks.xmpp.extensions.component.accept.model.ComponentMessage;
import rocks.xmpp.extensions.component.accept.model.ComponentPresence;
import rocks.xmpp.extensions.component.accept.model.Handshake;

public final class ExternalComponent
extends XmppSession {
    private static final Logger logger = Logger.getLogger(ExternalComponent.class.getName());
    private volatile CompletableFuture<SessionOpen> streamOpened;
    private volatile CompletableFuture<Void> handshakeReceived;
    private final String sharedSecret;
    private volatile Jid connectedResource;

    private ExternalComponent(String componentName, String sharedSecret, XmppSessionConfiguration configuration, ClientConnectionConfiguration connectionConfiguration) {
        super(componentName, configuration, new ClientConnectionConfiguration[]{connectionConfiguration});
        this.sharedSecret = sharedSecret;
    }

    public static ExternalComponent create(String componentName, String sharedSecret, String hostname, int port) {
        return ExternalComponent.create(componentName, sharedSecret, XmppSessionConfiguration.getDefault(), hostname, port);
    }

    public static ExternalComponent create(String componentName, String sharedSecret, XmppSessionConfiguration configuration, String hostname, int port) {
        return ExternalComponent.create(componentName, sharedSecret, configuration, (ClientConnectionConfiguration)((SocketConnectionConfiguration.Builder)((SocketConnectionConfiguration.Builder)SocketConnectionConfiguration.builder().hostname(hostname)).port(port)).build());
    }

    public static ExternalComponent create(String componentName, String sharedSecret, XmppSessionConfiguration xmppSessionConfiguration, ClientConnectionConfiguration connectionConfiguration) {
        ExternalComponent component = new ExternalComponent(componentName, sharedSecret, xmppSessionConfiguration, connectionConfiguration);
        ExternalComponent.notifyCreationListeners((XmppSession)component);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.preConnect();
        try {
            if (!this.checkConnected()) {
                this.updateStatus(XmppSession.Status.CONNECTING);
                ExternalComponent externalComponent = this;
                synchronized (externalComponent) {
                    this.streamOpened = new CompletableFuture();
                    if (!this.checkConnected()) {
                        this.exception = null;
                        this.tryConnect(from, "jabber:component:accept", "1.0");
                        logger.fine("Negotiating stream, waiting until handshake is ready to be negotiated.");
                        SessionOpen sessionOpen = this.streamOpened.get(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                        ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
                        if (sessionOpen != null && sessionOpen.getVersion() != null) {
                            this.streamFeaturesManager.completeNegotiation().get(this.configuration.getDefaultResponseTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS);
                        } else {
                            Thread.sleep(50L);
                        }
                        this.connectedResource = this.getDomain();
                    }
                }
            }
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
            this.updateStatus(XmppSession.Status.CONNECTING, XmppSession.Status.CONNECTED);
            this.login(this.sharedSecret);
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(String sharedSecret) throws XmppException {
        XmppSession.Status previousStatus = this.preLogin();
        try {
            if (this.checkAuthenticated()) {
                return;
            }
            this.updateStatus(XmppSession.Status.AUTHENTICATING);
            ExternalComponent externalComponent = this;
            synchronized (externalComponent) {
                this.handshakeReceived = new CompletableFuture();
                if (this.checkAuthenticated()) {
                    return;
                }
                this.send((StreamElement)Handshake.create((String)this.getActiveConnection().getStreamId(), (String)sharedSecret));
                this.handshakeReceived.get(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            this.updateStatus(XmppSession.Status.AUTHENTICATED);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
            this.afterLogin();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
        catch (Throwable e) {
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
    }

    public final boolean handleElement(Object element) throws XmppException {
        CompletableFuture<SessionOpen> future;
        boolean doRestart = false;
        if (element instanceof Handshake) {
            this.releaseLock();
        } else {
            doRestart = super.handleElement(element);
        }
        if (element instanceof SessionOpen && (future = this.streamOpened) != null) {
            future.complete((SessionOpen)element);
            this.streamOpened = null;
        }
        return doRestart;
    }

    public final void notifyException(Throwable e) {
        this.releaseLock();
        super.notifyException(e);
    }

    private void releaseLock() {
        CompletableFuture<Void> future2;
        CompletableFuture<SessionOpen> future = this.streamOpened;
        if (future != null) {
            future.complete(null);
            this.streamOpened = null;
        }
        if ((future2 = this.handshakeReceived) != null) {
            future2.complete(null);
            this.handshakeReceived = null;
        }
    }

    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    protected final StreamElement prepareElement(StreamElement element) {
        if (element instanceof Stanza && ((Stanza)element).getFrom() == null) {
            ((Stanza)element).setFrom(this.connectedResource);
        }
        if (element instanceof Message) {
            element = ComponentMessage.from((Message)((Message)element));
        } else if (element instanceof Presence) {
            element = ComponentPresence.from((Presence)((Presence)element));
        } else if (element instanceof IQ) {
            element = ComponentIQ.from((IQ)((IQ)element));
        }
        return element;
    }
}

