/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.langtrans;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.langtrans.model.LanguageTranslation;
import rocks.xmpp.extensions.langtrans.model.items.LanguageSupport;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class LanguageTranslationManager
extends Manager {
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    private LanguageTranslationManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public AsyncResult<List<Item>> discoverTranslationProviders() {
        return this.serviceDiscoveryManager.discoverServices(Identity.automationTranslation());
    }

    public AsyncResult<List<LanguageSupport.Item>> discoverLanguageSupport(Jid translationProvider) {
        return this.xmppSession.query(IQ.get((Jid)translationProvider, (Object)new LanguageSupport()), LanguageSupport.class).thenApply(LanguageSupport::getItems);
    }

    public AsyncResult<List<LanguageTranslation.Translation>> translate(Jid translationProvider, String text, Locale sourceLanguage, Locale ... destinationLanguage) {
        ArrayDeque<LanguageTranslation.Translation> translations = new ArrayDeque<LanguageTranslation.Translation>();
        for (Locale dl : destinationLanguage) {
            translations.add(LanguageTranslation.Translation.forDestinationLanguage((Locale)dl));
        }
        return this.xmppSession.query(IQ.get((Jid)translationProvider, (Object)new LanguageTranslation(text, sourceLanguage, translations)), LanguageTranslation.class).thenApply(languageTranslation -> languageTranslation != null ? languageTranslation.getTranslations() : Collections.emptyList());
    }
}

