/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.text.Collator;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.user.MucUser;

public final class Occupant
implements Comparable<Occupant> {
    private final Affiliation affiliation;
    private final Role role;
    private final Jid jid;
    private final String nick;
    private final boolean isSelf;
    private final Presence presence;

    Occupant(Presence presence, boolean isSelf) {
        this.presence = presence;
        this.nick = presence.getFrom().getResource();
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null && mucUser.getItem() != null) {
            this.affiliation = mucUser.getItem().getAffiliation();
            this.role = mucUser.getItem().getRole();
            this.jid = mucUser.getItem().getJid();
            this.isSelf = isSelf;
        } else {
            this.affiliation = null;
            this.role = null;
            this.jid = null;
            this.isSelf = isSelf;
        }
    }

    public Affiliation getAffiliation() {
        return this.affiliation;
    }

    public Role getRole() {
        return this.role;
    }

    public Jid getJid() {
        return this.jid;
    }

    public String getNick() {
        return this.nick;
    }

    public Presence getPresence() {
        return this.presence;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    @Override
    public int compareTo(Occupant o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            if (this.affiliation != null) {
                result = o.affiliation != null ? this.affiliation.compareTo((Enum)o.affiliation) : -1;
            } else {
                int n = result = o.affiliation != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.role != null) {
                    result = o.role != null ? this.role.compareTo((Enum)o.role) : -1;
                } else {
                    int n = result = o.role != null ? 1 : 0;
                }
            }
            if (result == 0) {
                result = this.presence.compareTo(o.presence);
            }
            if (result == 0) {
                if (this.nick != null) {
                    return o.nick != null ? Collator.getInstance().compare(this.nick, o.nick) : -1;
                }
                return o.nick != null ? 1 : 0;
            }
            return result;
        }
        return -1;
    }

    public String toString() {
        return this.nick;
    }
}

