/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc;

import java.util.ArrayList;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.rpc.RpcException;
import rocks.xmpp.extensions.rpc.RpcHandler;
import rocks.xmpp.extensions.rpc.model.Rpc;
import rocks.xmpp.extensions.rpc.model.Value;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class RpcManager
extends Manager {
    private static final Logger logger = Logger.getLogger(RpcManager.class.getName());
    private final IQHandler iqHandler = new AbstractIQHandler(new IQ.Type[]{IQ.Type.SET}){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IQ processRequest(IQ iq) {
            RpcHandler rpcHandler1;
            Rpc rpc = (Rpc)iq.getExtension(Rpc.class);
            1 var4_3 = this;
            synchronized (var4_3) {
                rpcHandler1 = RpcManager.this.rpcHandler;
            }
            if (rpcHandler1 != null) {
                Rpc.MethodCall methodCall = rpc.getMethodCall();
                ArrayList<Value> parameters = new ArrayList<Value>(methodCall.getParameters());
                try {
                    Value value = rpcHandler1.process(iq.getFrom(), methodCall.getMethodName(), parameters);
                    return iq.createResult((Object)Rpc.ofMethodResponse((Value)value));
                }
                catch (RpcException e1) {
                    return iq.createResult((Object)Rpc.ofFaultResponse((int)e1.getFaultCode(), (String)e1.getFaultString()));
                }
                catch (Throwable e1) {
                    logger.log(Level.WARNING, e1.getMessage(), e1);
                    return iq.createError(Condition.INTERNAL_SERVER_ERROR);
                }
            }
            return iq.createError(Condition.SERVICE_UNAVAILABLE);
        }
    };
    private RpcHandler rpcHandler;

    private RpcManager(XmppSession xmppSession) {
        super(xmppSession);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(Rpc.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(Rpc.class);
    }

    public AsyncResult<Value> call(Jid jid, String methodName, Value ... parameters) {
        AsyncResult query = this.xmppSession.query(IQ.set((Jid)jid, (Object)Rpc.ofMethodCall((String)methodName, (Value[])parameters)));
        return query.thenApply(result -> {
            Rpc.MethodResponse methodResponse;
            Rpc rpc;
            if (result != null && (rpc = (Rpc)result.getExtension(Rpc.class)) != null && (methodResponse = rpc.getMethodResponse()) != null) {
                if (methodResponse.getFault() != null) {
                    throw new CompletionException(new RpcException(methodResponse.getFault().getFaultCode(), methodResponse.getFault().getFaultString()));
                }
                return methodResponse.getResponse();
            }
            return null;
        });
    }

    public synchronized void setRpcHandler(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
        this.setEnabled(rpcHandler != null);
    }

    protected void dispose() {
        this.rpcHandler = null;
    }
}

