/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.shim;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class HeaderManager
extends Manager
implements InfoNode {
    private final Set<String> supportedHeaders = new CopyOnWriteArraySet<String>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    private HeaderManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public Set<String> getSupportedHeaders() {
        return this.supportedHeaders;
    }

    public String getNode() {
        return "http://jabber.org/protocol/shim";
    }

    public AsyncResult<List<String>> discoverSupportedHeaders(Jid jid) {
        return this.serviceDiscoveryManager.discoverInformation(jid, "http://jabber.org/protocol/shim").thenApply(infoNode -> infoNode.getFeatures().stream().map(feature -> feature.substring(feature.indexOf(35) + 1)).collect(Collectors.toList()));
    }

    protected void onEnable() {
        super.onEnable();
        this.serviceDiscoveryManager.addInfoNode((InfoNode)this);
    }

    protected void onDisable() {
        super.onDisable();
        this.serviceDiscoveryManager.removeInfoNode(this.getNode());
    }

    public Set<String> getFeatures() {
        return this.supportedHeaders.stream().map(supportedHeader -> "http://jabber.org/protocol/shim#" + supportedHeader).collect(Collectors.toSet());
    }

    public Set<Identity> getIdentities() {
        return null;
    }

    public List<DataForm> getExtensions() {
        return null;
    }
}

