/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2016 Christian Schudt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package rocks.xmpp.extensions.shim.client;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.shim.StanzaHeadersAndInternetMetadataProtocol;

/**
 * Manages support for <a href="https://xmpp.org/extensions/xep-0131.html">XEP-0131: Stanza Headers and Internet
 * Metadata</a>.
 *
 * <p>By default support is disabled, so that service discovery won't reveal the 'http://jabber.org/protocol/shim'
 * feature.</p>
 *
 * @author Christian Schudt
 */
public final class ClientHeaderManager extends StanzaHeadersAndInternetMetadataProtocol {

    private final XmppSession xmppSession;

    private ClientHeaderManager(XmppSession xmppSession) {
        super(xmppSession.getManager(ServiceDiscoveryManager.class));
        this.xmppSession = xmppSession;
    }

    @Override
    public final boolean addSupportedHeader(String header) {
        boolean result = super.addSupportedHeader(header);
        xmppSession.enableFeature(getNamespace());
        return result;
    }

    @Override
    public final boolean removeSupportedHeader(String header) {
        boolean result = super.removeSupportedHeader(header);
        if (getSupportedHeaders().isEmpty()) {
            xmppSession.disableFeature(getNamespace());
        }
        return result;
    }
}
