/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.EventObject;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.avatar.AbstractAvatarManager;
import rocks.xmpp.extensions.avatar.AvatarManager;

public final class AvatarChangeEvent
extends EventObject {
    private static final System.Logger LOGGER = System.getLogger(AvatarChangeEvent.class.getName());
    private final Jid contact;
    private final byte[] avatar;

    AvatarChangeEvent(AvatarManager source, Jid contact, byte[] avatar) {
        super(source);
        this.contact = contact;
        this.avatar = Arrays.copyOf(avatar, avatar.length);
    }

    public final byte[] getAvatar() {
        return this.avatar;
    }

    public final BufferedImage getAvatarImage() {
        try {
            return this.avatar == null ? null : AbstractAvatarManager.asBufferedImage(this.avatar);
        }
        catch (AbstractAvatarManager.ConversionException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Cannot convert avatar image");
            return null;
        }
    }

    public final Jid getContact() {
        return this.contact;
    }
}

