/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.avatar.AbstractAvatarManager;
import rocks.xmpp.extensions.avatar.AvatarChangeEvent;
import rocks.xmpp.extensions.avatar.UserAvatarProtocol;
import rocks.xmpp.extensions.vcard.avatar.VCardBasedAvatarsProtocol;
import rocks.xmpp.extensions.vcard.temp.VCardManager;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class CombinedAvatarManager
extends AbstractAvatarManager {
    private static final System.Logger logger = System.getLogger(VCardManager.class.getName());
    private final VCardBasedAvatarsProtocol vCardBasedAvatarsProtocol;
    private final UserAvatarProtocol userAvatarProtocol;

    private CombinedAvatarManager(XmppSession xmppSession) {
        super(xmppSession);
        this.vCardBasedAvatarsProtocol = (VCardBasedAvatarsProtocol)xmppSession.getManager(VCardBasedAvatarsProtocol.class);
        this.userAvatarProtocol = (UserAvatarProtocol)xmppSession.getManager(UserAvatarProtocol.class);
    }

    @Override
    public final AsyncResult<byte[]> getAvatar(Jid contact) {
        return this.vCardBasedAvatarsProtocol.getAvatar(contact.asBareJid());
    }

    @Override
    public final AsyncResult<Void> publishAvatar(byte[] imageData) {
        return this.vCardBasedAvatarsProtocol.publishAvatar(imageData).whenComplete((result, e) -> {
            if (e != null) {
                logger.log(System.Logger.Level.WARNING, "Failed to publish avatar to vCard.");
            }
        }).thenCompose(aVoid -> this.userAvatarProtocol.publishAvatar(imageData)).thenRun(() -> {});
    }

    @Override
    public final void addAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.vCardBasedAvatarsProtocol.addAvatarChangeListener(avatarChangeListener);
        this.userAvatarProtocol.addAvatarChangeListener(avatarChangeListener);
    }

    @Override
    public final void removeAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.vCardBasedAvatarsProtocol.removeAvatarChangeListener(avatarChangeListener);
        this.userAvatarProtocol.removeAvatarChangeListener(avatarChangeListener);
    }
}

