/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bookmarks;

import java.net.URL;
import java.util.ArrayDeque;
import java.util.List;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bookmarks.model.AbstractBookmark;
import rocks.xmpp.extensions.bookmarks.model.BookmarkStorage;
import rocks.xmpp.extensions.bookmarks.model.ChatRoomBookmark;
import rocks.xmpp.extensions.bookmarks.model.WebPageBookmark;
import rocks.xmpp.extensions.privatedata.PrivateDataManager;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class BookmarkManager
extends Manager {
    private final PrivateDataManager privateDataManager;

    private BookmarkManager(XmppSession xmppSession) {
        super(xmppSession);
        this.privateDataManager = (PrivateDataManager)xmppSession.getManager(PrivateDataManager.class);
    }

    public final AsyncResult<List<ChatRoomBookmark>> getChatRoomBookmarks() {
        return this.getBookmarks(ChatRoomBookmark.class);
    }

    public final AsyncResult<List<WebPageBookmark>> getWebPageBookmarks() {
        return this.getBookmarks(WebPageBookmark.class);
    }

    public final AsyncResult<Void> addBookmark(AbstractBookmark bookmark) {
        return this.privateDataManager.getData(BookmarkStorage.class).thenCompose(bookmarkStorage -> {
            ArrayDeque<AbstractBookmark> bookmarks = new ArrayDeque<AbstractBookmark>(bookmarkStorage.getBookmarks());
            bookmarks.remove(bookmark);
            bookmarks.add(bookmark);
            return this.privateDataManager.storeData((Object)new BookmarkStorage(bookmarks));
        });
    }

    public final AsyncResult<Void> removeChatRoomBookmark(Jid chatRoom) {
        return this.privateDataManager.getData(BookmarkStorage.class).thenCompose(bookmarkStorage -> {
            ArrayDeque bookmarks = new ArrayDeque(bookmarkStorage.getBookmarks());
            bookmarks.remove(new ChatRoomBookmark("", chatRoom));
            return this.privateDataManager.storeData((Object)new BookmarkStorage(bookmarks));
        });
    }

    public final AsyncResult<Void> removeWebPageBookmark(URL webPage) {
        return this.privateDataManager.getData(BookmarkStorage.class).thenCompose(bookmarkStorage -> {
            ArrayDeque bookmarks = new ArrayDeque(bookmarkStorage.getBookmarks());
            bookmarks.remove(new WebPageBookmark("", webPage));
            return this.privateDataManager.storeData((Object)new BookmarkStorage(bookmarks));
        });
    }

    private <T extends AbstractBookmark> AsyncResult<List<T>> getBookmarks(Class<T> clazz) {
        return this.privateDataManager.getData(BookmarkStorage.class).thenApply(bookmarkStorage -> bookmarkStorage.getBookmarks().stream().filter(bookmark -> bookmark.getClass() == clazz).map(bookmark -> bookmark).sorted().collect(Collectors.toList()));
    }
}

