/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbEvent;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class InBandByteStreamManager
extends ByteStreamManager
implements IQHandler,
InboundMessageHandler,
ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("http://jabber.org/protocol/ibb");
    private static final System.Logger logger = System.getLogger(InBandByteStreamManager.class.getName());
    final Map<String, IbbSession> ibbSessionMap = new ConcurrentHashMap<String, IbbSession>();
    private final IQHandler iqHandler;
    private InBandByteStream.Open.StanzaType stanzaType = InBandByteStream.Open.StanzaType.IQ;

    private InBandByteStreamManager(final XmppSession xmppSession) {
        super(xmppSession);
        this.iqHandler = new AbstractIQHandler(InBandByteStream.class, new IQ.Type[]{IQ.Type.SET}){

            protected IQ processRequest(IQ iq) {
                InBandByteStream ibb = (InBandByteStream)iq.getExtension(InBandByteStream.class);
                if (ibb instanceof InBandByteStream.Open) {
                    InBandByteStream.Open open = (InBandByteStream.Open)ibb;
                    if (open.getBlockSize() > 65535) {
                        return iq.createError(new StanzaError(StanzaError.Type.MODIFY, Condition.RESOURCE_CONSTRAINT));
                    }
                    XmppUtils.notifyEventListeners((Iterable)InBandByteStreamManager.this.byteStreamListeners, (EventObject)new IbbEvent((Object)InBandByteStreamManager.this, open.getSessionId(), xmppSession, iq, open.getBlockSize(), open.getStanzaType()));
                    return null;
                }
                if (ibb instanceof InBandByteStream.Data) {
                    InBandByteStream.Data data = (InBandByteStream.Data)ibb;
                    IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(data.getSessionId());
                    if (ibbSession != null) {
                        if (ibbSession.dataReceived(data)) {
                            return iq.createResult();
                        }
                        return iq.createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST));
                    }
                    return iq.createError(Condition.ITEM_NOT_FOUND);
                }
                if (ibb instanceof InBandByteStream.Close) {
                    InBandByteStream.Close close = (InBandByteStream.Close)ibb;
                    IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(close.getSessionId());
                    if (ibbSession != null) {
                        try {
                            InBandByteStreamManager.this.ibbSessionMap.remove(close.getSessionId());
                            ibbSession.closedByPeer();
                            return iq.createResult();
                        }
                        catch (IOException e1) {
                            logger.log(System.Logger.Level.WARNING, e1.getMessage(), (Throwable)e1);
                            return iq.createResult();
                        }
                    }
                    return iq.createError(Condition.ITEM_NOT_FOUND);
                }
                return iq.createError(Condition.SERVICE_UNAVAILABLE);
            }
        };
    }

    IbbSession createSession(Jid receiver, String sessionId, int blockSize, InBandByteStream.Open.StanzaType stanzaType) {
        IbbSession ibbSession = new IbbSession(sessionId, this.xmppSession, receiver, blockSize, this.xmppSession.getConfiguration().getDefaultResponseTimeout(), this, stanzaType);
        this.ibbSessionMap.put(ibbSession.getSessionId(), ibbSession);
        return ibbSession;
    }

    public final AsyncResult<ByteStreamSession> initiateSession(Jid receiver, String sessionId, int blockSize) {
        if (blockSize > 65535) {
            throw new IllegalArgumentException("blockSize must not be greater than 65535.");
        }
        IbbSession ibbSession = this.createSession(receiver, sessionId, blockSize, this.getStanzaType());
        return ibbSession.open().thenApply(result -> ibbSession);
    }

    @Override
    public final AsyncResult<ByteStreamSession> initiateSession(Jid receiver, String sessionId) {
        return this.initiateSession(receiver, sessionId, 4096);
    }

    public final synchronized InBandByteStream.Open.StanzaType getStanzaType() {
        return this.stanzaType;
    }

    public final synchronized void setStanzaType(InBandByteStream.Open.StanzaType stanzaType) {
        this.stanzaType = stanzaType;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.ibbSessionMap.clear();
    }

    public Class<?> getPayloadClass() {
        return this.iqHandler.getPayloadClass();
    }

    public IQ handleRequest(IQ iq) {
        return this.iqHandler.handleRequest(iq);
    }

    public void handleInboundMessage(MessageEvent e) {
        InBandByteStream.Data data = (InBandByteStream.Data)e.getMessage().getExtension(InBandByteStream.Data.class);
        if (data != null) {
            IbbSession ibbSession = this.ibbSessionMap.get(data.getSessionId());
            if (ibbSession != null) {
                if (!ibbSession.dataReceived(data)) {
                    this.xmppSession.send((StreamElement)e.getMessage().createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST)));
                }
            } else {
                this.xmppSession.send((StreamElement)e.getMessage().createError(Condition.ITEM_NOT_FOUND));
            }
        }
    }

    public final String getNamespace() {
        return "http://jabber.org/protocol/ibb";
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }
}

