/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;

final class Socks5Protocol {
    private Socks5Protocol() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void establishClientConnection(Socket socket, String destinationAddress, int destinationPort) throws IOException {
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(new byte[]{5, 1, 0});
        outputStream.flush();
        byte[] response = new byte[2];
        inputStream.readFully(response);
        if (response[0] != 5 || response[1] != 0) throw new IOException("Unable to connect to SOCKS5 server.");
        byte[] dstAddr = destinationAddress.getBytes(StandardCharsets.UTF_8);
        byte[] dstPort = new byte[]{(byte)(destinationPort >>> 8), (byte)destinationPort};
        byte[] requestDetails = new byte[]{5, 1, 0, 3, (byte)dstAddr.length};
        byte[] request = new byte[7 + dstAddr.length];
        System.arraycopy(requestDetails, 0, request, 0, requestDetails.length);
        System.arraycopy(dstAddr, 0, request, requestDetails.length, dstAddr.length);
        System.arraycopy(dstPort, 0, request, requestDetails.length + dstAddr.length, dstPort.length);
        outputStream.write(request);
        outputStream.flush();
        byte[] reply = Socks5Protocol.readRequestOrReply(inputStream);
        if (reply[1] != 0) throw new IOException("SOCKS5 server returned error code " + reply[1]);
        request[1] = 0;
        if (Arrays.equals(reply, request)) return;
        throw new IOException("Verification failed.");
    }

    static String establishServerConnection(Socket socket, Collection<String> allowedAddresses) throws IOException {
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        OutputStream outputStream = socket.getOutputStream();
        if (inputStream.read() != 5) {
            throw new IOException("Client provided invalid SOCKS version.");
        }
        byte[] methods = new byte[inputStream.read()];
        inputStream.readFully(methods);
        boolean noAuthRequired = false;
        for (byte method : methods) {
            if (method != 0) continue;
            noAuthRequired = true;
            break;
        }
        outputStream.write(5);
        if (!noAuthRequired) {
            outputStream.write(-1);
            outputStream.flush();
            throw new IOException("Client provided unsupported authentication methods.");
        }
        outputStream.write(0);
        outputStream.flush();
        byte[] request = Socks5Protocol.readRequestOrReply(inputStream);
        String dstAddr = new String(request, 5, (int)request[4], StandardCharsets.UTF_8);
        if (!allowedAddresses.contains(dstAddr)) {
            request[1] = 5;
            outputStream.write(request);
            outputStream.flush();
            throw new IOException("Connection refused");
        }
        request[1] = 0;
        outputStream.write(request);
        outputStream.flush();
        return new String(request, 5, (int)request[4], StandardCharsets.UTF_8);
    }

    private static byte[] readRequestOrReply(DataInputStream in) throws IOException {
        byte[] firstHalf = new byte[5];
        in.readFully(firstHalf, 0, 5);
        if (firstHalf[0] != 5) {
            throw new IOException("Invalid SOCKS version.");
        }
        if (firstHalf[3] != 3) {
            throw new IOException("Unsupported SOCKS5 address type");
        }
        byte addressLength = firstHalf[4];
        byte[] message = new byte[7 + addressLength];
        System.arraycopy(firstHalf, 0, message, 0, firstHalf.length);
        in.readFully(message, firstHalf.length, addressLength + 2);
        return message;
    }
}

