/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.EventObject;
import java.util.List;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.model.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.model.Range;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class FileTransferOfferEvent
extends EventObject
implements FileTransferOffer {
    private final transient FileTransferOffer fileTransferOffer;
    private final transient IQ iq;
    private final String mimeType;
    private final String sessionId;
    private final transient FileTransferNegotiator fileTransferNegotiator;
    private final transient Object protocol;

    FileTransferOfferEvent(Object source, IQ iq, String sessionId, String mimeType, FileTransferOffer fileTransferOffer, Object protocol, FileTransferNegotiator fileTransferNegotiator) {
        super(source);
        this.sessionId = sessionId;
        this.iq = iq;
        this.fileTransferOffer = fileTransferOffer;
        this.mimeType = mimeType;
        this.fileTransferNegotiator = fileTransferNegotiator;
        this.protocol = protocol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Jid getInitiator() {
        return this.iq.getFrom();
    }

    public AsyncResult<FileTransfer> accept(OutputStream outputStream) {
        return this.fileTransferNegotiator.accept(this.iq, this.sessionId, this.fileTransferOffer, this.protocol, outputStream);
    }

    public final AsyncResult<FileTransfer> accept(Path destination) throws IOException {
        return this.accept(Files.newOutputStream(destination, new OpenOption[0]));
    }

    public final AsyncResult<FileTransfer> accept(File target) throws IOException {
        return this.accept(target.toPath());
    }

    public void reject() {
        this.fileTransferNegotiator.reject(this.iq);
    }

    public long getSize() {
        return this.fileTransferOffer.getSize();
    }

    public String getName() {
        return this.fileTransferOffer.getName();
    }

    public Instant getDate() {
        return this.fileTransferOffer.getDate();
    }

    public List<Hash> getHashes() {
        return this.fileTransferOffer.getHashes();
    }

    public String getDescription() {
        return this.fileTransferOffer.getDescription();
    }

    public Range getRange() {
        return this.fileTransferOffer.getRange();
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

