/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.offline;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.offline.model.OfflineMessage;
import rocks.xmpp.extensions.offline.model.OfflineMessageHeader;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class OfflineMessageManager {
    private final XmppSession xmppSession;

    private OfflineMessageManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    public AsyncResult<Boolean> isSupported() {
        EntityCapabilitiesManager entityCapabilitiesManager = (EntityCapabilitiesManager)this.xmppSession.getManager(EntityCapabilitiesManager.class);
        return entityCapabilitiesManager.discoverCapabilities(this.xmppSession.getDomain()).thenApply(infoNode -> infoNode.getFeatures().contains("http://jabber.org/protocol/offline"));
    }

    public AsyncResult<Integer> requestNumberOfMessages() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        return serviceDiscoveryManager.discoverInformation(null, "http://jabber.org/protocol/offline").thenApply(infoDiscovery -> {
            DataForm dataForm;
            if (!infoDiscovery.getExtensions().isEmpty() && (dataForm = (DataForm)infoDiscovery.getExtensions().get(0)) != null) {
                for (DataForm.Field field : dataForm.getFields()) {
                    if (!"number_of_messages".equals(field.getName())) continue;
                    String numberOfMessages = (String)field.getValues().get(0);
                    return Integer.valueOf(numberOfMessages);
                }
            }
            return 0;
        });
    }

    public AsyncResult<List<OfflineMessageHeader>> requestMessageHeaders() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        return serviceDiscoveryManager.discoverItems(null, "http://jabber.org/protocol/offline").thenApply(itemNode -> itemNode.getItems().stream().map(item -> new OfflineMessageHeader(Jid.of((CharSequence)item.getName()), item.getNode())).collect(Collectors.toList()));
    }

    public AsyncResult<IQ> requestMessage(String id) {
        return this.xmppSession.query(IQ.get((Object)new OfflineMessage(new OfflineMessage.Item[]{new OfflineMessage.Item(id, OfflineMessage.Item.Action.VIEW)})));
    }

    public AsyncResult<IQ> removeMessages(String ... ids) {
        ArrayList<OfflineMessage.Item> items = new ArrayList<OfflineMessage.Item>();
        for (String id : ids) {
            items.add(new OfflineMessage.Item(id, OfflineMessage.Item.Action.REMOVE));
        }
        return this.xmppSession.query(IQ.set((Object)new OfflineMessage(items)));
    }

    public AsyncResult<IQ> requestAllMessages() {
        return this.xmppSession.query(IQ.get((Object)new OfflineMessage(true, false)));
    }

    public AsyncResult<IQ> removeAllMessages() {
        return this.xmppSession.query(IQ.set((Object)new OfflineMessage(false, true)));
    }
}

