/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.privacy.PrivacyListEvent;
import rocks.xmpp.extensions.privacy.model.Privacy;
import rocks.xmpp.extensions.privacy.model.PrivacyList;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class PrivacyListManager
extends AbstractIQHandler
implements ExtensionProtocol {
    private final Set<Consumer<PrivacyListEvent>> privacyListListeners = new CopyOnWriteArraySet<Consumer<PrivacyListEvent>>();
    private final XmppSession xmppSession;

    private PrivacyListManager(XmppSession xmppSession) {
        super(Privacy.class, new IQ.Type[]{IQ.Type.SET});
        this.xmppSession = xmppSession;
    }

    protected IQ processRequest(IQ iq) {
        if (iq.getFrom() == null || iq.getFrom().equals(this.xmppSession.getConnectedResource().asBareJid())) {
            List privacyLists;
            Privacy privacy = (Privacy)iq.getExtension(Privacy.class);
            if (privacy != null && (privacyLists = privacy.getPrivacyLists()).size() == 1) {
                XmppUtils.notifyEventListeners(this.privacyListListeners, (EventObject)new PrivacyListEvent((Object)this, ((PrivacyList)privacyLists.get(0)).getName()));
            }
            return iq.createResult();
        }
        return iq.createError(Condition.NOT_ACCEPTABLE);
    }

    public void addPrivacyListListener(Consumer<PrivacyListEvent> privacyListListener) {
        this.privacyListListeners.add(privacyListListener);
        this.xmppSession.enableFeature(this.getNamespace());
    }

    public void removePrivacyListListener(Consumer<PrivacyListEvent> privacyListListener) {
        this.privacyListListeners.remove(privacyListListener);
        if (this.privacyListListeners.isEmpty()) {
            this.xmppSession.disableFeature(this.getNamespace());
        }
    }

    public AsyncResult<Collection<PrivacyList>> getPrivacyLists() {
        return this.xmppSession.query(IQ.get((Object)new Privacy())).thenApply(result -> {
            Privacy privacy = (Privacy)result.getExtension(Privacy.class);
            ArrayList<PrivacyList> privacyLists = new ArrayList<PrivacyList>();
            for (PrivacyList privacyList : privacy.getPrivacyLists()) {
                if (privacyList.getName() != null && privacyList.getName().equals(privacy.getDefaultName())) {
                    privacyLists.add(privacyList.asDefault());
                }
                if (privacyList.getName() == null || !privacyList.getName().equals(privacy.getActiveName())) continue;
                privacyLists.add(privacyList.asActive());
            }
            return privacyLists;
        });
    }

    public AsyncResult<PrivacyList> getPrivacyList(String name) {
        return this.xmppSession.query(IQ.get((Object)new Privacy(new PrivacyList[]{new PrivacyList(name)}))).thenApply(result -> {
            Privacy privacy = (Privacy)result.getExtension(Privacy.class);
            if (privacy != null) {
                return (PrivacyList)privacy.getPrivacyLists().get(0);
            }
            return null;
        });
    }

    public AsyncResult<IQ> setActiveList(String name) {
        return this.setPrivacy(Privacy.withActive((String)name));
    }

    public AsyncResult<IQ> declineActiveList() {
        return this.setActiveList("");
    }

    public AsyncResult<IQ> setDefaultList(String name) {
        return this.setPrivacy(Privacy.withDefault((String)name));
    }

    public AsyncResult<IQ> declineDefaultList() {
        return this.setDefaultList("");
    }

    public AsyncResult<IQ> createOrUpdateList(PrivacyList privacyList) {
        return this.setPrivacy(new Privacy(new PrivacyList[]{privacyList}));
    }

    public AsyncResult<IQ> removeList(String name) {
        return this.setPrivacy(new Privacy(new PrivacyList[]{new PrivacyList(name)}));
    }

    private AsyncResult<IQ> setPrivacy(Privacy privacy) {
        return this.xmppSession.query(IQ.set((Object)privacy));
    }

    public final String getNamespace() {
        return "jabber:iq:privacy";
    }

    public final boolean isEnabled() {
        return !this.privacyListListeners.isEmpty();
    }
}

