/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.NodeConfiguration;
import rocks.xmpp.extensions.pubsub.model.NodeMetaData;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PublishOptions;
import rocks.xmpp.extensions.pubsub.model.SubscribeOptions;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class PubSubNode {
    private final Jid pubSubServiceAddress;
    private final XmppSession xmppSession;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private volatile NodeType type;
    private volatile String nodeId;

    PubSubNode(String nodeId, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this(nodeId, nodeId == null ? NodeType.LEAF : NodeType.COLLECTION, pubSubServiceAddress, xmppSession);
    }

    PubSubNode(String nodeId, NodeType type, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this.nodeId = nodeId;
        this.type = type;
        this.pubSubServiceAddress = pubSubServiceAddress;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public AsyncResult<NodeMetaData> discoverNodeMetaData() {
        if (this.nodeId == null) {
            throw new IllegalStateException("nodeId must not be null.");
        }
        return this.serviceDiscoveryManager.discoverInformation(this.pubSubServiceAddress, this.nodeId).thenApply(infoNode -> {
            Identity identity = null;
            NodeMetaData metaDataForm = null;
            if (infoNode != null) {
                Set identities = infoNode.getIdentities();
                Iterator iterator = identities.iterator();
                if (iterator.hasNext()) {
                    identity = (Identity)iterator.next();
                }
                for (DataForm dataForm : infoNode.getExtensions()) {
                    String formType = dataForm.getFormType();
                    if (!"http://jabber.org/protocol/pubsub#meta-data".equals(formType)) continue;
                    metaDataForm = new NodeMetaData(dataForm);
                    break;
                }
            }
            this.type = identity != null ? ("collection".equals(identity.getType()) ? NodeType.COLLECTION : NodeType.LEAF) : NodeType.LEAF;
            return metaDataForm;
        });
    }

    public AsyncResult<List<rocks.xmpp.extensions.disco.model.items.Item>> discoverItems() {
        return this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId).thenApply(ItemNode::getItems);
    }

    public AsyncResult<List<Subscription>> getSubscriptions() {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withSubscriptions((String)this.nodeId))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getSubscriptions());
    }

    public AsyncResult<List<Affiliation>> getAffiliations() {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withAffiliations((String)this.nodeId))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getAffiliations());
    }

    public AsyncResult<Subscription> subscribe() {
        return this.subscribe(this.xmppSession.getConnectedResource().asBareJid(), null);
    }

    public AsyncResult<Subscription> subscribe(SubscribeOptions subscribeOptions) {
        return this.subscribe(this.xmppSession.getConnectedResource().asBareJid(), subscribeOptions);
    }

    public final AsyncResult<Subscription> subscribe(Jid jid) {
        return this.subscribe(jid, null);
    }

    public final AsyncResult<Subscription> subscribe(Jid jid, SubscribeOptions subscribeOptions) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withSubscribe((String)Objects.requireNonNull(this.nodeId, "nodeId must not be null"), (Jid)Objects.requireNonNull(jid), (DataForm)(subscribeOptions != null ? subscribeOptions.getDataForm() : null)))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getSubscription());
    }

    public void unsubscribe() {
        this.unsubscribe(null);
    }

    public AsyncResult<IQ> unsubscribe(String subscriptionId) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withUnsubscribe((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (String)subscriptionId)));
    }

    public AsyncResult<SubscribeOptions> getSubscriptionOptions(boolean defaultOptions) {
        if (defaultOptions) {
            return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withDefault((String)this.nodeId))).thenApply(result -> new SubscribeOptions(((PubSub)result.getExtension(PubSub.class)).getDefault().getDataForm()));
        }
        return this.getSubscriptionOptions();
    }

    public AsyncResult<SubscribeOptions> getSubscriptionOptions() {
        return this.getSubscriptionOptions(null);
    }

    public AsyncResult<SubscribeOptions> getSubscriptionOptions(String subId) {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (String)subId, null))).thenApply(result -> new SubscribeOptions(((PubSub)result.getExtension(PubSub.class)).getOptions().getDataForm()));
    }

    public AsyncResult<IQ> configureSubscription(SubscribeOptions subscribeOptions) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), null, (DataForm)(subscribeOptions != null ? subscribeOptions.getDataForm() : null))));
    }

    public AsyncResult<List<Item>> getItems() {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withItems((String)this.nodeId))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getItems());
    }

    public AsyncResult<List<Item>> getItems(String ... ids) {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withItems((String)this.nodeId, (String[])ids))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getItems());
    }

    public AsyncResult<List<Item>> getItems(int maxItems) {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSub.withItems((String)this.nodeId, (int)maxItems))).thenApply(result -> ((PubSub)result.getExtension(PubSub.class)).getItems());
    }

    public AsyncResult<String> publish(Object item) {
        return this.publish(null, item);
    }

    public AsyncResult<String> publish(Object item, PublishOptions publishOptions) {
        return this.publish(null, item, publishOptions);
    }

    public AsyncResult<String> publish(String id, Object item) {
        return this.publish(id, item, null);
    }

    public AsyncResult<String> publish(String id, Object item, PublishOptions publishOptions) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withPublish((String)this.nodeId, (String)id, (Object)item, (DataForm)(publishOptions != null ? publishOptions.getDataForm() : null)))).thenApply(result -> {
            PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
            if (pubSub != null && pubSub.getPublish() != null && pubSub.getPublish().getItem() != null) {
                return pubSub.getPublish().getItem().getId();
            }
            return id;
        });
    }

    public AsyncResult<IQ> deleteItem(String id, boolean notify) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withRetract((String)this.nodeId, (String)id, (boolean)notify)));
    }

    public AsyncResult<String> create() {
        return this.create(null);
    }

    public AsyncResult<String> create(NodeConfiguration nodeConfiguration) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSub.withCreate((String)this.nodeId, (DataForm)(nodeConfiguration != null ? nodeConfiguration.getDataForm() : null)))).thenApply(result -> {
            String generatedNodeId;
            if (this.nodeId != null) {
                return this.nodeId;
            }
            PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
            if (pubSub != null && (generatedNodeId = pubSub.getNode()) != null) {
                this.nodeId = generatedNodeId;
            }
            return this.nodeId;
        });
    }

    public AsyncResult<NodeConfiguration> getNodeConfiguration() {
        return this.xmppSession.query(IQ.get((Jid)this.pubSubServiceAddress, (Object)PubSubOwner.withConfigure((String)this.nodeId))).thenApply(result -> {
            PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
            return new NodeConfiguration(pubSubOwner.getConfigurationForm());
        });
    }

    public AsyncResult<IQ> configureNode(NodeConfiguration nodeConfiguration) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSubOwner.withConfigure((String)this.nodeId, (DataForm)nodeConfiguration.getDataForm())));
    }

    public AsyncResult<IQ> delete() {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSubOwner.withDelete((String)this.nodeId)));
    }

    public AsyncResult<IQ> delete(URI uri) {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSubOwner.withDelete((String)this.nodeId, (URI)uri)));
    }

    public AsyncResult<IQ> purge() {
        return this.xmppSession.query(IQ.set((Jid)this.pubSubServiceAddress, (Object)PubSubOwner.withPurge((String)this.nodeId)));
    }

    public AsyncResult<List<PubSubNode>> discoverNodes() {
        return this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId).thenApply(itemNode -> itemNode.getItems().stream().map(item -> new PubSubNode(item.getNode(), this.pubSubServiceAddress, this.xmppSession)).collect(Collectors.toList()));
    }

    public String getId() {
        return this.nodeId;
    }

    public NodeType getType() {
        return this.type;
    }

    public String toString() {
        return this.nodeId;
    }
}

