/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.messagecorrect.model.Replace;
import rocks.xmpp.extensions.rtt.InboundRealTimeMessage;
import rocks.xmpp.extensions.rtt.OutboundRealTimeMessage;
import rocks.xmpp.extensions.rtt.RealTimeMessageEvent;
import rocks.xmpp.extensions.rtt.RealTimeTextActivationEvent;
import rocks.xmpp.extensions.rtt.model.RealTimeText;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.XmppUtils;

public final class RealTimeTextManager
implements InboundMessageHandler,
ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("urn:xmpp:rtt:0");
    private final Map<TrackingKey, InboundRealTimeMessage> realTimeMessageMap = new ConcurrentHashMap<TrackingKey, InboundRealTimeMessage>();
    private final Set<Consumer<RealTimeTextActivationEvent>> realTimeTextActivationListeners = new CopyOnWriteArraySet<Consumer<RealTimeTextActivationEvent>>();
    private final Set<Consumer<RealTimeMessageEvent>> inboundRealTimeMessageListeners = new CopyOnWriteArraySet<Consumer<RealTimeMessageEvent>>();
    private final XmppSession xmppSession;

    RealTimeTextManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    public final OutboundRealTimeMessage createRealTimeMessage(Chat chat, String id) {
        return new OutboundRealTimeMessage(chat, id, 700L, 10000L);
    }

    public final OutboundRealTimeMessage createRealTimeMessage(Chat chat) {
        return this.createRealTimeMessage(chat, null);
    }

    public final void addRealTimeMessageListener(Consumer<RealTimeMessageEvent> realTimeMessageListener) {
        this.inboundRealTimeMessageListeners.add(realTimeMessageListener);
    }

    public final void addRealTimeTextActivationListener(Consumer<RealTimeTextActivationEvent> realTimeTextListener) {
        this.realTimeTextActivationListeners.add(realTimeTextListener);
    }

    public final void removeRealTimeTextActivationListener(Consumer<RealTimeTextActivationEvent> realTimeTextListener) {
        this.realTimeTextActivationListeners.remove(realTimeTextListener);
    }

    public final void activate(Chat chat) {
        Message message = new Message();
        RealTimeText realTimeText = new RealTimeText(RealTimeText.Event.INIT, Collections.emptyList(), 0, null);
        message.addExtension((Object)realTimeText);
        chat.sendMessage(message);
    }

    public final void deactivate(Chat chat) {
        Message message = new Message();
        RealTimeText realTimeText = new RealTimeText(RealTimeText.Event.CANCEL, Collections.emptyList(), 0, null);
        message.addExtension((Object)realTimeText);
        chat.sendMessage(message);
    }

    public final void handleInboundMessage(MessageEvent e) {
        Message message = e.getMessage();
        if (message.getType() == Message.Type.CHAT || message.getType() == Message.Type.GROUPCHAT) {
            Replace replace;
            String id;
            TrackingKey trackingKey;
            InboundRealTimeMessage realTimeMessage;
            Jid sender = message.getFrom();
            Jid trackingJid = message.getType() == Message.Type.CHAT ? sender.asBareJid() : sender;
            RealTimeText rtt = (RealTimeText)message.getExtension(RealTimeText.class);
            if (rtt != null && rtt.getSequence() != null) {
                InboundRealTimeMessage realTimeMessage2;
                TrackingKey trackingKey2 = new TrackingKey(trackingJid, rtt.getId());
                if (rtt.getEvent() == null || rtt.getEvent() == RealTimeText.Event.EDIT) {
                    realTimeMessage2 = this.realTimeMessageMap.get(trackingKey2);
                    if (realTimeMessage2 != null && realTimeMessage2.getSequence() + 1 == rtt.getSequence()) {
                        realTimeMessage2.processActions(rtt.getActions(), true);
                    }
                } else if (rtt.getEvent() == RealTimeText.Event.RESET) {
                    realTimeMessage2 = this.realTimeMessageMap.get(trackingKey2);
                    if (realTimeMessage2 != null) {
                        realTimeMessage2.reset(rtt.getSequence(), rtt.getId());
                    } else {
                        realTimeMessage2 = new InboundRealTimeMessage(this.xmppSession, message.getFrom(), rtt.getSequence(), rtt.getId());
                        this.realTimeMessageMap.put(trackingKey2, realTimeMessage2);
                        XmppUtils.notifyEventListeners(this.inboundRealTimeMessageListeners, (EventObject)new RealTimeMessageEvent(this, realTimeMessage2));
                    }
                    realTimeMessage2.processActions(rtt.getActions(), false);
                } else if (rtt.getEvent() == RealTimeText.Event.NEW) {
                    realTimeMessage2 = new InboundRealTimeMessage(this.xmppSession, message.getFrom(), rtt.getSequence(), rtt.getId());
                    InboundRealTimeMessage oldRealTimeMessage = this.realTimeMessageMap.put(trackingKey2, realTimeMessage2);
                    if (oldRealTimeMessage != null) {
                        oldRealTimeMessage.complete();
                    }
                    XmppUtils.notifyEventListeners(this.inboundRealTimeMessageListeners, (EventObject)new RealTimeMessageEvent(this, realTimeMessage2));
                    realTimeMessage2.processActions(rtt.getActions(), false);
                } else if (rtt.getEvent() == RealTimeText.Event.CANCEL) {
                    XmppUtils.notifyEventListeners(this.realTimeTextActivationListeners, (EventObject)new RealTimeTextActivationEvent(this, sender, false));
                } else if (rtt.getEvent() == RealTimeText.Event.INIT) {
                    XmppUtils.notifyEventListeners(this.realTimeTextActivationListeners, (EventObject)new RealTimeTextActivationEvent(this, sender, true));
                }
            }
            if (message.getBody() != null && (realTimeMessage = this.realTimeMessageMap.remove(trackingKey = new TrackingKey(trackingJid, id = (replace = (Replace)message.getExtension(Replace.class)) != null ? replace.getId() : null))) != null) {
                realTimeMessage.complete();
            }
        }
    }

    public final String getNamespace() {
        return "urn:xmpp:rtt:0";
    }

    public final boolean isEnabled() {
        return !this.inboundRealTimeMessageListeners.isEmpty();
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }

    private static final class TrackingKey {
        private final Jid sender;
        private final String id;

        private TrackingKey(Jid sender, String id) {
            this.sender = sender;
            this.id = id;
        }

        public int hashCode() {
            return Objects.hash(this.sender, this.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackingKey)) {
                return false;
            }
            TrackingKey other = (TrackingKey)o;
            return Objects.equals(this.sender, other.sender) && Objects.equals(this.id, other.id);
        }
    }
}

