/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.vcard.avatar;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.InboundPresenceHandler;
import rocks.xmpp.core.stanza.OutboundPresenceHandler;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.avatar.AbstractAvatarManager;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.vcard.avatar.model.AvatarUpdate;
import rocks.xmpp.extensions.vcard.temp.VCardManager;
import rocks.xmpp.extensions.vcard.temp.model.VCard;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class VCardBasedAvatarsProtocol
extends AbstractAvatarManager
implements InboundPresenceHandler,
OutboundPresenceHandler,
ExtensionProtocol {
    private static final System.Logger logger = System.getLogger(VCardBasedAvatarsProtocol.class.getName());
    final Set<String> nonConformingResources = Collections.synchronizedSet(new HashSet());
    final Map<Jid, String> userHashes = new ConcurrentHashMap<Jid, String>();
    private final Map<String, byte[]> hashesLocalStore;
    private final VCardManager vCardManager;
    private final Map<Jid, AsyncResult<byte[]>> avatarRequests = new ConcurrentHashMap<Jid, AsyncResult<byte[]>>();

    VCardBasedAvatarsProtocol(XmppSession xmppSession) {
        this(xmppSession, (VCardManager)((Object)xmppSession.getManager(VCardManager.class)), (Map<String, byte[]>)(xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("userhashes")) : Collections.synchronizedMap(new HashMap())));
    }

    VCardBasedAvatarsProtocol(XmppSession xmppSession, VCardManager vCardManager, Map<String, byte[]> hashesLocalStore) {
        super(xmppSession);
        this.vCardManager = vCardManager;
        this.hashesLocalStore = hashesLocalStore;
        this.restoreUserHashes();
        xmppSession.addSessionStatusListener(sessionStatusEvent -> {
            if (sessionStatusEvent.getStatus() == XmppSession.Status.CLOSED) {
                this.backupUserHashes();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void handleInboundPresence(PresenceEvent e) {
        Jid contact;
        Presence presence = e.getPresence();
        AvatarUpdate avatarUpdate = (AvatarUpdate)presence.getExtension(AvatarUpdate.class);
        if (presence.getFrom().asBareJid().equals(this.xmppSession.getLocalXmppAddress().asBareJid()) && presence.getFrom().getResource() != null && !presence.getFrom().getResource().equals(this.xmppSession.getLocalXmppAddress().getResource())) {
            if (avatarUpdate == null) {
                if (presence.isAvailable()) {
                    this.nonConformingResources.add(presence.getFrom().getResource());
                } else if (presence.getType() == Presence.Type.UNAVAILABLE && this.nonConformingResources.remove(presence.getFrom().getResource()) && this.nonConformingResources.isEmpty()) {
                    this.resetHash();
                }
            } else if (avatarUpdate.getHash() != null && !avatarUpdate.getHash().equals(this.userHashes.get(this.xmppSession.getLocalXmppAddress().asBareJid()))) {
                this.resetHash();
            }
        }
        if (avatarUpdate == null || avatarUpdate.getHash() == null) return;
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null) {
            if (mucUser.getItem() == null || mucUser.getItem().getJid() == null) return;
            contact = mucUser.getItem().getJid().asBareJid();
        } else {
            contact = presence.getFrom().asBareJid();
        }
        if (avatarUpdate.getHash().equals(this.userHashes.put(contact, avatarUpdate.getHash()))) return;
        byte[] imageData = this.loadFromCache(avatarUpdate.getHash());
        byte[] avatar = null;
        if (imageData != null) {
            avatar = imageData;
        }
        if (avatar != null) {
            this.notifyListeners(contact, avatar);
            return;
        } else {
            this.getAvatar(contact).whenComplete((avatarResult, ex) -> {
                if (ex == null) {
                    this.notifyListeners(contact, (byte[])avatarResult);
                } else {
                    logger.log(System.Logger.Level.WARNING, () -> "Failed to retrieve vCard based avatar for user: " + contact, (Throwable)ex);
                }
            });
        }
    }

    void resetHash() {
        this.userHashes.remove(this.xmppSession.getLocalXmppAddress().asBareJid());
        Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
        if (presence == null) {
            presence = new Presence();
        }
        presence.getExtensions().clear();
        this.xmppSession.send((StreamElement)presence);
    }

    public final void handleOutboundPresence(PresenceEvent e) {
        Presence presence = e.getPresence();
        if (presence.isAvailable() && this.nonConformingResources.isEmpty()) {
            String myHash = this.userHashes.get(this.xmppSession.getLocalXmppAddress().asBareJid());
            if (myHash == null) {
                presence.putExtension((Object)new AvatarUpdate());
                this.getAvatar(this.xmppSession.getLocalXmppAddress().asBareJid()).whenComplete((avatarResult, ex) -> {
                    if (ex == null) {
                        this.notifyListeners(this.xmppSession.getLocalXmppAddress().asBareJid(), (byte[])avatarResult);
                        Presence lastPresence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
                        Presence presence1 = lastPresence != null ? new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null) : new Presence();
                        this.xmppSession.send((StreamElement)presence1);
                    } else {
                        logger.log(System.Logger.Level.WARNING, "Failed to retrieve own vCard based avatar.");
                    }
                });
            } else if (!presence.hasExtension(AvatarUpdate.class)) {
                presence.putExtension((Object)new AvatarUpdate(myHash));
            }
        }
    }

    @Override
    public final AsyncResult<byte[]> getAvatar(Jid contact) {
        String hash = this.userHashes.get(contact.asBareJid());
        if (!"".equals(hash)) {
            byte[] imageData;
            if (hash != null && (imageData = this.loadFromCache(hash)) != null) {
                return new AsyncResult(CompletableFuture.completedFuture(imageData));
            }
            return this.avatarRequests.computeIfAbsent(contact.asBareJid(), key -> {
                AsyncResult<VCard> vCard = this.vCardManager.getVCard(contact);
                return vCard.handle((result, exc) -> {
                    VCard.Image image;
                    if (exc != null && !(exc instanceof StanzaErrorException)) {
                        throw new CompletionException((Throwable)exc);
                    }
                    byte[] avatar = new byte[]{};
                    String hash1 = "";
                    if (result != null && (image = result.getPhoto()) != null && image.getValue() != null) {
                        hash1 = XmppUtils.hash((byte[])image.getValue());
                        avatar = image.getValue();
                    }
                    this.userHashes.put(contact.asBareJid(), hash1);
                    if (!Arrays.equals(avatar, new byte[0])) {
                        this.storeToCache(hash1, avatar);
                    }
                    return avatar;
                });
            }).whenComplete((avatar, exc) -> this.avatarRequests.remove(contact.asBareJid()));
        }
        return new AsyncResult(CompletableFuture.completedFuture(new byte[0]));
    }

    @Override
    public final AsyncResult<Void> publishAvatar(byte[] avatar) {
        String hash = avatar != null ? XmppUtils.hash((byte[])avatar) : null;
        return this.vCardManager.getVCard().handle((result, exc) -> result != null ? result : new VCard()).thenCompose(vCard -> {
            if (avatar != null) {
                if (vCard.getPhoto() == null || !Arrays.equals(vCard.getPhoto().getValue(), avatar)) {
                    this.userHashes.put(this.xmppSession.getLocalXmppAddress().asBareJid(), hash);
                    vCard.setPhoto(new VCard.Image(null, avatar));
                    return this.vCardManager.setVCard((VCard)vCard);
                }
            } else {
                this.userHashes.put(this.xmppSession.getLocalXmppAddress().asBareJid(), "");
                if (vCard.getPhoto() != null && vCard.getPhoto().getValue() != null) {
                    vCard.setPhoto(null);
                    return this.vCardManager.setVCard((VCard)vCard);
                }
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private void backupUserHashes() {
        this.userHashes.forEach((jid, hash) -> this.hashesLocalStore.put(jid + ".userhash", hash.getBytes(StandardCharsets.UTF_16)));
    }

    private void restoreUserHashes() {
        this.hashesLocalStore.forEach((jid, hash) -> this.userHashes.put(Jid.of((CharSequence)jid.replace(".userhash", "")), new String((byte[])hash, StandardCharsets.UTF_16)));
    }

    public final String getNamespace() {
        return "vcard-temp:x:update";
    }

    public final boolean isEnabled() {
        return !this.avatarChangeListeners.isEmpty();
    }
}

