/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.geoloc.model;

import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.util.adapters.ZoneOffsetAdapter;

@XmlRootElement(name="geoloc")
public final class GeoLocation {
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    private final Double accuracy;
    private final Double alt;
    private final Double altaccuracy;
    private final String area;
    private final Double bearing;
    private final String building;
    private final String country;
    @XmlElement(name="countrycode")
    private final String countryCode;
    private final String datum;
    private final String description;
    private final String floor;
    private final Double lat;
    private final String locality;
    private final Double lon;
    @XmlElement(name="postalcode")
    private final String postalCode;
    private final String region;
    private final String room;
    private final Double speed;
    private final String street;
    private final String text;
    private final Instant timestamp;
    @XmlJavaTypeAdapter(value=ZoneOffsetAdapter.class)
    private final ZoneOffset tzo;
    private final URI uri;

    private GeoLocation() {
        this.accuracy = null;
        this.alt = null;
        this.altaccuracy = null;
        this.area = null;
        this.bearing = null;
        this.building = null;
        this.country = null;
        this.countryCode = null;
        this.datum = null;
        this.description = null;
        this.floor = null;
        this.lang = null;
        this.lat = null;
        this.locality = null;
        this.lon = null;
        this.postalCode = null;
        this.region = null;
        this.room = null;
        this.speed = null;
        this.street = null;
        this.text = null;
        this.timestamp = null;
        this.tzo = null;
        this.uri = null;
    }

    private GeoLocation(Builder builder) {
        this.accuracy = builder.accuracy;
        this.alt = builder.alt;
        this.altaccuracy = builder.altaccuracy;
        this.area = builder.area;
        this.bearing = builder.bearing;
        this.building = builder.building;
        this.country = builder.country;
        this.countryCode = builder.countryCode;
        this.datum = builder.datum;
        this.description = builder.description;
        this.floor = builder.floor;
        this.lang = builder.language;
        this.lat = builder.latitude;
        this.locality = builder.locality;
        this.lon = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
        this.room = builder.room;
        this.speed = builder.speed;
        this.street = builder.street;
        this.text = builder.text;
        this.timestamp = builder.timestamp;
        this.tzo = builder.zoneOffset;
        this.uri = builder.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Double getAccuracy() {
        return this.accuracy;
    }

    public final Double getAltitude() {
        return this.alt;
    }

    public final Double getAltitudeAccuracy() {
        return this.altaccuracy;
    }

    public final String getArea() {
        return this.area;
    }

    public final Double getBearing() {
        return this.bearing;
    }

    public final String getBuilding() {
        return this.building;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final String getDatum() {
        return this.datum;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getFloor() {
        return this.floor;
    }

    public final Double getLatitude() {
        return this.lat;
    }

    public final String getLocality() {
        return this.locality;
    }

    public final Double getLongitude() {
        return this.lon;
    }

    public final String getPostalCode() {
        return this.postalCode;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getRoom() {
        return this.room;
    }

    public final Double getSpeed() {
        return this.speed;
    }

    public final String getStreet() {
        return this.street;
    }

    public final String getText() {
        return this.text;
    }

    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final Locale getLanguage() {
        return this.lang;
    }

    public final ZoneOffset getTimeZoneOffset() {
        return this.tzo;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Geolocation: ");
        if (this.accuracy != null) {
            sb.append("Accuracy: ").append(this.accuracy).append("m; ");
        }
        if (this.alt != null) {
            sb.append("Altitude: ").append(this.alt).append("m; ");
        }
        if (this.altaccuracy != null) {
            sb.append("Altitude Accuracy: ").append(this.altaccuracy).append("m; ");
        }
        if (this.area != null) {
            sb.append("Area: ").append(this.area).append("; ");
        }
        if (this.bearing != null) {
            sb.append("Bearing: ").append(this.bearing).append("\u00b0; ");
        }
        if (this.building != null) {
            sb.append("Building: ").append(this.building).append("; ");
        }
        if (this.country != null) {
            sb.append("Country: ").append(this.country).append("; ");
        }
        if (this.countryCode != null) {
            sb.append("Country Code: ").append(this.countryCode).append("; ");
        }
        if (this.datum != null) {
            sb.append("Datum: ").append(this.datum).append("; ");
        }
        if (this.description != null) {
            sb.append("Description: ").append(this.description).append("; ");
        }
        if (this.floor != null) {
            sb.append("Floor: ").append(this.floor).append("; ");
        }
        if (this.lat != null) {
            sb.append("Latitude: ").append(this.lat).append("\u00b0; ");
        }
        if (this.locality != null) {
            sb.append("Locality: ").append(this.locality).append("; ");
        }
        if (this.lon != null) {
            sb.append("Longitude: ").append(this.lon).append("\u00b0; ");
        }
        if (this.postalCode != null) {
            sb.append("Postal Code: ").append(this.postalCode).append("; ");
        }
        if (this.region != null) {
            sb.append("Region: ").append(this.region).append("; ");
        }
        if (this.room != null) {
            sb.append("Room: ").append(this.room).append("; ");
        }
        if (this.speed != null) {
            sb.append("Speed: ").append(this.speed).append("m/s; ");
        }
        if (this.street != null) {
            sb.append("Street: ").append(this.street).append("; ");
        }
        if (this.text != null) {
            sb.append("Text: ").append(this.text).append("; ");
        }
        if (this.timestamp != null) {
            sb.append("Timestamp: ").append(this.timestamp).append("; ");
        }
        if (this.tzo != null) {
            sb.append("Time Zone: ").append(this.tzo).append("; ");
        }
        if (this.uri != null) {
            sb.append("URI: ").append(this.uri).append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public static final class Builder {
        private Locale language;
        private Double accuracy;
        private Double alt;
        private Double altaccuracy;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum;
        private String description;
        private String floor;
        private Double latitude;
        private String locality;
        private Double longitude;
        private String postalCode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Instant timestamp;
        private ZoneOffset zoneOffset;
        private URI uri;

        private Builder() {
        }

        public Builder language(Locale language) {
            this.language = language;
            return this;
        }

        public Builder accuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder altitude(Double altitude) {
            this.alt = altitude;
            return this;
        }

        public Builder altitudeAccuracy(Double altitudeAccuracy) {
            this.altaccuracy = altitudeAccuracy;
            return this;
        }

        public Builder area(String area) {
            this.area = area;
            return this;
        }

        public Builder bearing(Double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder building(String building) {
            this.building = building;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder datum(String datum) {
            this.datum = datum;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder floor(String floor) {
            this.floor = floor;
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder room(String room) {
            this.room = room;
            return this;
        }

        public Builder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timeZoneOffset(ZoneOffset zoneOffset) {
            this.zoneOffset = zoneOffset;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}

