/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.langtrans.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.extensions.langtrans.model.items.LanguageSupport;

@XmlRootElement(name="x")
@XmlSeeAlso(value={LanguageSupport.class})
public final class LanguageTranslation {
    public static final String NAMESPACE = "urn:xmpp:langtrans";
    @XmlElement(name="translation")
    private final List<Translation> translations = new ArrayList<Translation>();
    @XmlElement
    private final Source source;

    private LanguageTranslation() {
        this.source = null;
    }

    public LanguageTranslation(Translation ... translations) {
        this(Arrays.asList(translations));
    }

    public LanguageTranslation(Collection<Translation> translations) {
        this.source = null;
        this.translations.addAll(translations);
    }

    public LanguageTranslation(String sourceText, Locale sourceLanguage, Collection<Translation> translations) {
        this.source = new Source(sourceText, sourceLanguage);
        this.translations.addAll(translations);
    }

    public final List<Translation> getTranslations() {
        return Collections.unmodifiableList(this.translations);
    }

    public final String getSourceText() {
        return this.source != null ? this.source.getText() : null;
    }

    public final Locale getSourceLanguage() {
        return this.source != null ? this.source.getLanguage() : null;
    }

    public static final class Translation {
        @XmlValue
        private final String text;
        @XmlAttribute(name="destination_lang")
        private final Locale destinationLanguage;
        @XmlAttribute(name="source_lang")
        private final Locale sourceLanguage;
        @XmlAttribute(name="engine")
        private final String engine;
        @XmlAttribute(name="dictionary")
        private final String dictionary;
        @XmlAttribute(name="reviewed")
        private final Boolean reviewed;

        private Translation() {
            this.destinationLanguage = null;
            this.sourceLanguage = null;
            this.engine = null;
            this.dictionary = null;
            this.reviewed = null;
            this.text = null;
        }

        private Translation(Locale destinationLanguage, Locale sourceLanguage, String engine, String dictionary, Boolean reviewed, String text) {
            this.destinationLanguage = Objects.requireNonNull(destinationLanguage);
            this.sourceLanguage = sourceLanguage;
            this.engine = engine;
            this.dictionary = dictionary;
            this.reviewed = reviewed;
            this.text = text;
        }

        public static Translation forDestinationLanguage(Locale destinationLanguage) {
            return new Translation(destinationLanguage, null, null, null, null, null);
        }

        public Translation withSourceLanguage(Locale sourceLanguage) {
            return new Translation(this.destinationLanguage, sourceLanguage, this.engine, this.dictionary, this.reviewed, this.text);
        }

        public Translation withEngine(String engine) {
            return new Translation(this.destinationLanguage, this.sourceLanguage, engine, this.dictionary, this.reviewed, this.text);
        }

        public Translation withDictionary(String dictionary) {
            return new Translation(this.destinationLanguage, this.sourceLanguage, this.engine, dictionary, this.reviewed, this.text);
        }

        public Translation withReviewed(boolean reviewed) {
            return new Translation(this.destinationLanguage, this.sourceLanguage, this.engine, this.dictionary, reviewed, this.text);
        }

        public Translation withTranslatedText(String text) {
            return new Translation(this.destinationLanguage, this.sourceLanguage, this.engine, this.dictionary, this.reviewed, text);
        }

        public final Locale getDestinationLanguage() {
            return this.destinationLanguage;
        }

        public final Locale getSourceLanguage() {
            return this.sourceLanguage;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final String getTranslatedText() {
            return this.text;
        }

        public final String getDictionary() {
            return this.dictionary;
        }

        public final boolean isReviewed() {
            return this.reviewed != null && this.reviewed != false;
        }
    }

    private static final class Source {
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private final Locale language;
        @XmlValue
        private final String text;

        private Source() {
            this.text = null;
            this.language = null;
        }

        private Source(String text, Locale language) {
            this.text = Objects.requireNonNull(text);
            this.language = Objects.requireNonNull(language);
        }

        private Locale getLanguage() {
            return this.language;
        }

        private String getText() {
            return this.text;
        }
    }
}

