/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.privacy.model.PrivacyRule;

public final class PrivacyList
implements Comparable<PrivacyList> {
    private final List<PrivacyRule> item = new ArrayList<PrivacyRule>();
    @XmlAttribute
    private final String name;
    @XmlTransient
    private boolean isActive;
    @XmlTransient
    private boolean isDefault;

    private PrivacyList() {
        this.name = null;
    }

    public PrivacyList(String name, Collection<PrivacyRule> items) {
        this.name = Objects.requireNonNull(name);
        if (items != null) {
            this.item.addAll(items);
        }
    }

    public PrivacyList(String name) {
        this.name = name;
    }

    public static PrivacyList createInvisibilityList() {
        return PrivacyList.createInvisibilityListExceptForUsers("invisible", new Jid[0]);
    }

    public static PrivacyList createInvisibilityListExceptForUsers(String listName, Jid ... jids) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(PrivacyRule.of(jid, PrivacyRule.Action.ALLOW, order++).appliedToOutboundPresence());
        }
        rules.add(PrivacyRule.blockOutboundPresence(order));
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListExceptForGroups(String listName, String ... groups) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(PrivacyRule.of(group, PrivacyRule.Action.ALLOW, order++).appliedToOutboundPresence());
        }
        rules.add(PrivacyRule.blockOutboundPresence(order));
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForUsers(String listName, Jid ... jids) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(PrivacyRule.blockPresenceTo(jid, order++));
        }
        rules.add(PrivacyRule.of(PrivacyRule.Action.ALLOW, order).appliedToOutboundPresence());
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForGroups(String listName, String ... groups) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(PrivacyRule.blockPresenceToRosterGroup(group, order++));
        }
        rules.add(PrivacyRule.of(PrivacyRule.Action.ALLOW, order).appliedToOutboundPresence());
        return new PrivacyList(listName, rules);
    }

    public final List<PrivacyRule> getPrivacyRules() {
        return Collections.unmodifiableList(this.item);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final PrivacyList asActive() {
        PrivacyList privacyList = new PrivacyList(this.name, this.item);
        privacyList.isActive = true;
        return privacyList;
    }

    public final PrivacyList asDefault() {
        PrivacyList privacyList = new PrivacyList(this.name, this.item);
        privacyList.isDefault = true;
        return privacyList;
    }

    @Override
    public final int compareTo(PrivacyList o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            if (this.isDefault) {
                if (o.isDefault) {
                    return this.name != null ? Collator.getInstance().compare(this.name, o.name) : 1;
                }
                return -1;
            }
            if (this.isActive) {
                if (o.isDefault) {
                    return 1;
                }
                if (o.isActive) {
                    return this.name != null ? Collator.getInstance().compare(this.name, o.name) : 1;
                }
                return -1;
            }
            if (o.isDefault || o.isActive) {
                return 1;
            }
            return this.name != null ? Collator.getInstance().compare(this.name, o.name) : 1;
        }
        return -1;
    }

    public final String toString() {
        return this.name;
    }
}

