/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.im.roster.model.SubscriptionState;

public final class PrivacyRule
implements Comparable<PrivacyRule> {
    @XmlAttribute
    private final Type type;
    @XmlAttribute
    private final String value;
    @XmlAttribute
    private final Action action;
    @XmlAttribute
    private final long order;
    private final String message;
    @XmlElement(name="presence-in")
    private final String presenceIn;
    @XmlElement(name="presence-out")
    private final String presenceOut;
    private final String iq;

    private PrivacyRule() {
        this.action = null;
        this.order = 0L;
        this.type = null;
        this.value = null;
        this.message = null;
        this.presenceIn = null;
        this.presenceOut = null;
        this.iq = null;
    }

    private PrivacyRule(Action action, long order, Type type, String value, boolean filterMessage, boolean filterPresenceIn, boolean filterPresenceOut, boolean filterIQ) {
        if (order < 0L) {
            throw new IllegalArgumentException("order must be greater 0.");
        }
        this.action = Objects.requireNonNull(action);
        this.order = order;
        this.type = type;
        this.value = value;
        this.message = filterMessage ? "" : null;
        this.presenceIn = filterPresenceIn ? "" : null;
        this.presenceOut = filterPresenceOut ? "" : null;
        this.iq = filterIQ ? "" : null;
    }

    public static PrivacyRule of(Action action, long order) {
        return new PrivacyRule(action, order, null, null, false, false, false, false);
    }

    public static PrivacyRule of(Jid jid, Action action, long order) {
        return new PrivacyRule(action, order, Type.JID, jid.toEscapedString(), false, false, false, false);
    }

    public static PrivacyRule of(String group, Action action, long order) {
        return new PrivacyRule(action, order, Type.GROUP, group, false, false, false, false);
    }

    public static PrivacyRule of(SubscriptionState.Subscription subscription, Action action, long order) {
        if (SubscriptionState.Subscription.REMOVE.equals((Object)subscription)) {
            throw new IllegalArgumentException("subscription must not be 'remove'");
        }
        return new PrivacyRule(action, order, Type.SUBSCRIPTION, subscription.name().toLowerCase(), false, false, false, false);
    }

    public static PrivacyRule blockMessagesFrom(Jid entity, long order) {
        return new PrivacyRule(Action.DENY, order, Type.JID, entity.toEscapedString(), true, false, false, false);
    }

    public static PrivacyRule blockMessagesFromRosterGroup(String rosterGroup, long order) {
        return new PrivacyRule(Action.DENY, order, Type.GROUP, Objects.requireNonNull(rosterGroup), true, false, false, false);
    }

    public static PrivacyRule blockMessagesFromEntitiesWithSubscription(SubscriptionState.Subscription subscription, long order) {
        return new PrivacyRule(Action.DENY, order, Type.SUBSCRIPTION, PrivacyRule.checkSubscriptionType(subscription), true, false, false, false);
    }

    public static PrivacyRule blockPresenceFrom(Jid entity, long order) {
        return new PrivacyRule(Action.DENY, order, Type.JID, entity.toEscapedString(), false, true, false, false);
    }

    public static PrivacyRule blockPresenceFromRosterGroup(String rosterGroup, long order) {
        return new PrivacyRule(Action.DENY, order, Type.GROUP, Objects.requireNonNull(rosterGroup), false, true, false, false);
    }

    public static PrivacyRule blockPresenceFromEntitiesWithSubscription(SubscriptionState.Subscription subscription, long order) {
        return new PrivacyRule(Action.DENY, order, Type.SUBSCRIPTION, PrivacyRule.checkSubscriptionType(subscription), false, true, false, false);
    }

    public static PrivacyRule blockInboundPresence(long order) {
        return new PrivacyRule(Action.DENY, order, null, null, false, true, false, false);
    }

    public static PrivacyRule blockPresenceTo(Jid entity, long order) {
        return new PrivacyRule(Action.DENY, order, Type.JID, entity.toEscapedString(), false, false, true, false);
    }

    public static PrivacyRule blockPresenceToRosterGroup(String rosterGroup, long order) {
        return new PrivacyRule(Action.DENY, order, Type.GROUP, Objects.requireNonNull(rosterGroup), false, false, true, false);
    }

    public static PrivacyRule blockPresenceToEntitiesWithSubscription(SubscriptionState.Subscription subscription, long order) {
        return new PrivacyRule(Action.DENY, order, Type.SUBSCRIPTION, PrivacyRule.checkSubscriptionType(subscription), false, false, true, false);
    }

    public static PrivacyRule blockOutboundPresence(long order) {
        return new PrivacyRule(Action.DENY, order, null, null, false, false, true, false);
    }

    public static PrivacyRule blockIQFrom(Jid entity, long order) {
        return new PrivacyRule(Action.DENY, order, Type.JID, entity.toEscapedString(), false, false, false, true);
    }

    public static PrivacyRule blockIQFromRosterGroup(String rosterGroup, long order) {
        return new PrivacyRule(Action.DENY, order, Type.GROUP, Objects.requireNonNull(rosterGroup), false, false, false, true);
    }

    public static PrivacyRule blockIQFromEntitiesWithSubscription(SubscriptionState.Subscription subscription, long order) {
        return new PrivacyRule(Action.DENY, order, Type.SUBSCRIPTION, PrivacyRule.checkSubscriptionType(subscription), false, false, false, true);
    }

    public static PrivacyRule blockAllCommunicationWithRosterGroup(String rosterGroup, long order) {
        return new PrivacyRule(Action.DENY, order, Type.GROUP, Objects.requireNonNull(rosterGroup), false, false, false, false);
    }

    public static PrivacyRule blockAllCommunicationWithEntitiesWithSubscription(SubscriptionState.Subscription subscription, long order) {
        return new PrivacyRule(Action.DENY, order, Type.SUBSCRIPTION, PrivacyRule.checkSubscriptionType(subscription), false, false, false, false);
    }

    public static PrivacyRule blockAllCommunicationWith(Jid entity, long order) {
        return new PrivacyRule(Action.DENY, order, Type.JID, entity.toEscapedString(), false, false, false, false);
    }

    private static String checkSubscriptionType(SubscriptionState.Subscription subscription) {
        if (SubscriptionState.Subscription.REMOVE.equals((Object)subscription)) {
            throw new IllegalArgumentException("subscription must not be 'remove'");
        }
        return subscription.name().toLowerCase();
    }

    public final Type getType() {
        return this.type;
    }

    public final Action getAction() {
        return this.action;
    }

    public final String getValue() {
        return this.value;
    }

    public final long getOrder() {
        return this.order;
    }

    public final boolean isAppliedToMessages() {
        return this.message != null || this.isAppliedToEverything();
    }

    public final PrivacyRule appliedToMessages() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, true, this.presenceIn != null, this.presenceOut != null, this.iq != null);
    }

    public final boolean isAppliedToIQs() {
        return this.iq != null || this.isAppliedToEverything();
    }

    public final PrivacyRule appliedToIQs() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, this.presenceIn != null, this.presenceOut != null, true);
    }

    public final boolean isAppliedToInboundPresence() {
        return this.presenceIn != null || this.isAppliedToEverything();
    }

    public final PrivacyRule appliedToInboundPresence() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, true, this.presenceOut != null, this.iq != null);
    }

    public final boolean isAppliedToOutboundPresence() {
        return this.presenceOut != null || this.isAppliedToEverything();
    }

    public final PrivacyRule appliedToOutboundPresence() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, this.presenceIn != null, true, this.iq != null);
    }

    private boolean isAppliedToEverything() {
        return this.presenceIn == null && this.presenceOut == null && this.message == null && this.iq == null;
    }

    @Override
    public final int compareTo(PrivacyRule o) {
        if (this == o) {
            return 0;
        }
        return o != null ? Long.compare(this.order, o.order) : -1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.action.name().toLowerCase()).append(", ").append(this.order);
        if (this.type != null) {
            sb.append(", ").append(this.type.name().toLowerCase());
        }
        if (this.value != null) {
            sb.append(", ").append(this.value);
        }
        return sb.toString();
    }

    public static enum Action {
        ALLOW,
        DENY;

    }

    public static enum Type {
        GROUP,
        JID,
        SUBSCRIPTION;

    }
}

