/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.AccessModel;
import rocks.xmpp.extensions.pubsub.model.SendLastPublishedItem;

public final class PublishOptions {
    private static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#publish-options";
    private static final String ACCESS_MODEL = "pubsub#access_model";
    private static final String PERSIST_ITEMS = "pubsub#persist_items";
    private static final String SEND_LAST_PUBLISHED_ITEM = "pubsub#send_last_published_item";
    private static final String ROSTER_GROUPS_ALLOWED = "pubsub#roster_groups_allowed";
    private final DataForm dataForm;

    public PublishOptions(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PublishOptions forStorageOfPublicData(AccessModel accessModel) {
        return PublishOptions.builder().persistItems(true).sendLastPublishedItem(SendLastPublishedItem.NEVER).accessModel(accessModel).build();
    }

    public static PublishOptions forStorageOfPrivateData() {
        return PublishOptions.builder().persistItems(true).accessModel(AccessModel.WHITELIST).build();
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final AccessModel getAccessModel() {
        String value = this.dataForm.findValue(ACCESS_MODEL);
        if (value != null) {
            return AccessModel.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final Boolean isPersistItems() {
        return this.dataForm.findValueAsBoolean(PERSIST_ITEMS);
    }

    public final SendLastPublishedItem getSendLastPublishedItem() {
        String value = this.dataForm.findValue(SEND_LAST_PUBLISHED_ITEM);
        if (value != null) {
            return SendLastPublishedItem.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final List<String> getRosterGroupsAllowed() {
        return this.dataForm.findValues(ROSTER_GROUPS_ALLOWED);
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private AccessModel accessModel;
        private Boolean persistItems;
        private SendLastPublishedItem sendLastPublishedItem;
        private Collection<String> rosterGroupsAllowed;

        public final Builder accessModel(AccessModel accessModel) {
            this.accessModel = accessModel;
            return this;
        }

        public final Builder persistItems(boolean persistItems) {
            this.persistItems = persistItems;
            return this;
        }

        public final Builder sendLastPublishedItem(SendLastPublishedItem sendLastPublishedItem) {
            this.sendLastPublishedItem = sendLastPublishedItem;
            return this;
        }

        public final Builder rosterGroupsAllowed(Collection<String> rosterGroupsAllowed) {
            this.rosterGroupsAllowed = rosterGroupsAllowed;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public PublishOptions build() {
            ArrayDeque<DataForm.Field> fields = new ArrayDeque<DataForm.Field>();
            if (this.accessModel != null) {
                fields.add(DataForm.Field.builder().var(PublishOptions.ACCESS_MODEL).value(this.accessModel.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.persistItems != null) {
                fields.add(DataForm.Field.builder().var(PublishOptions.PERSIST_ITEMS).value(this.persistItems.booleanValue()).build());
            }
            if (this.sendLastPublishedItem != null) {
                fields.add(DataForm.Field.builder().var(PublishOptions.SEND_LAST_PUBLISHED_ITEM).value(this.sendLastPublishedItem.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.rosterGroupsAllowed != null && !this.rosterGroupsAllowed.isEmpty()) {
                fields.add(DataForm.Field.builder().var(PublishOptions.ROSTER_GROUPS_ALLOWED).values(this.rosterGroupsAllowed).type(DataForm.Field.Type.LIST_MULTI).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(PublishOptions.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new PublishOptions(new DataForm((DataForm.Builder)this));
        }
    }
}

