/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model.event;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="event")
public final class Event {
    @XmlElements(value={@XmlElement(name="configuration", type=Configuration.class), @XmlElement(name="delete", type=Delete.class), @XmlElement(name="items", type=Items.class), @XmlElement(name="purge", type=Purge.class), @XmlElement(name="subscription", type=SubscriptionInfo.class)})
    private final PubSubEventChildElement type = null;

    private Event() {
    }

    public final String getNode() {
        return this.type != null ? this.type.getNode() : null;
    }

    public final boolean isConfiguration() {
        return this.type instanceof Configuration;
    }

    public final boolean isDelete() {
        return this.type instanceof Delete;
    }

    public final boolean isPurge() {
        return this.type instanceof Purge;
    }

    public final Subscription getSubscription() {
        if (this.type instanceof SubscriptionInfo) {
            return (SubscriptionInfo)this.type;
        }
        return null;
    }

    public final List<Item> getItems() {
        if (this.type instanceof Items) {
            return Collections.unmodifiableList(((Items)this.type).item);
        }
        return Collections.emptyList();
    }

    public final DataForm getConfigurationForm() {
        if (this.type instanceof Configuration) {
            return ((Configuration)this.type).dataForm;
        }
        return null;
    }

    public final URI getRedirectUri() {
        if (this.type instanceof Delete && ((Delete)this.type).redirect != null) {
            return ((Delete)this.type).redirect.uri;
        }
        return null;
    }

    @XmlTransient
    private static abstract class PubSubEventChildElement {
        @XmlAttribute
        private final String node;

        private PubSubEventChildElement() {
            this((String)null);
        }

        private PubSubEventChildElement(String node) {
            this.node = node;
        }

        public final String getNode() {
            return this.node;
        }
    }

    private static final class ItemElement
    implements Item {
        @XmlAnyElement(lax=true)
        private final Object object = null;
        @XmlAttribute
        private final String id;
        @XmlAttribute
        private final String node;
        @XmlAttribute
        private final String publisher;

        private ItemElement() {
            this.publisher = null;
            this.node = null;
            this.id = null;
        }

        @Override
        public final Object getPayload() {
            return this.object;
        }

        @Override
        public final String getId() {
            return this.id;
        }

        @Override
        public final String getNode() {
            return this.node;
        }

        @Override
        public final String getPublisher() {
            return this.publisher;
        }
    }

    private static final class SubscriptionInfo
    extends PubSubEventChildElement
    implements Subscription {
        @XmlAttribute
        @XmlJavaTypeAdapter(value=InstantAdapter.class)
        private final Instant expiry = null;
        @XmlAttribute
        private final Jid jid = null;
        @XmlAttribute
        private final String subid;
        @XmlAttribute
        private final SubscriptionState subscription = null;

        private SubscriptionInfo() {
            this.subid = null;
        }

        @Override
        public final Jid getJid() {
            return this.jid;
        }

        @Override
        public final String getSubId() {
            return this.subid;
        }

        @Override
        public final SubscriptionState getSubscriptionState() {
            return this.subscription;
        }

        @Override
        public final Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public final boolean isConfigurationRequired() {
            return false;
        }

        @Override
        public final boolean isConfigurationSupported() {
            return false;
        }
    }

    private static final class Retract {
        @XmlAttribute
        private final String node;
        @XmlAttribute
        private final Boolean notify;
        private final ItemElement item;
        @XmlAttribute
        private final String id;

        private Retract() {
            this(null, null, null);
        }

        private Retract(String node, ItemElement item, Boolean notify) {
            this.node = node;
            this.item = item;
            this.notify = notify;
            this.id = null;
        }
    }

    private static final class Purge
    extends PubSubEventChildElement {
        private Purge() {
        }
    }

    private static final class Items
    extends PubSubEventChildElement {
        private final List<ItemElement> item = new ArrayList<ItemElement>();
        @XmlAttribute(name="max_items")
        private final Long maxItems;
        @XmlAttribute
        private final String subid;
        private final Retract retract;

        private Items() {
            this((String)null, (Long)null);
        }

        private Items(String node, Long maxItems) {
            super(node);
            this.maxItems = maxItems;
            this.subid = null;
            this.retract = null;
        }
    }

    private static final class Delete
    extends PubSubEventChildElement {
        private final Redirect redirect = null;

        private Delete() {
        }

        private static final class Redirect {
            @XmlAttribute
            private final URI uri;

            private Redirect() {
                this(null);
            }

            private Redirect(URI uri) {
                this.uri = uri;
            }
        }
    }

    private static final class Configuration
    extends PubSubEventChildElement {
        @XmlElementRef
        private final DataForm dataForm = null;

        private Configuration() {
        }
    }
}

