/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.search.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;

@XmlRootElement(name="query")
public final class Search {
    public static final String NAMESPACE = "jabber:iq:search";
    private final List<Item> item = new ArrayList<Item>();
    private final String instructions;
    private final String first;
    private final String last;
    private final String nick;
    private final String email;
    @XmlElementRef
    private final DataForm form;
    @XmlElementRef
    private final ResultSetManagement resultSet;

    public Search() {
        this(null, null, null, null);
    }

    public Search(String first, String last, String nick, String email) {
        this(first, last, nick, email, null, null, null);
    }

    public Search(String first, String last, String nick, String email, ResultSetManagement resultSet, String instructions, DataForm dataForm) {
        this.first = first;
        this.last = last;
        this.nick = nick;
        this.email = email;
        this.resultSet = resultSet;
        this.instructions = instructions;
        this.form = dataForm;
    }

    public final String getInstructions() {
        return this.instructions;
    }

    public final String getFirst() {
        return this.first;
    }

    public final String getLast() {
        return this.last;
    }

    public final String getNick() {
        return this.nick;
    }

    public final String getEmail() {
        return this.email;
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.item);
    }

    public final DataForm getAdditionalInformation() {
        return this.form;
    }

    public final ResultSetManagement getResultSet() {
        return this.resultSet;
    }

    public static final class Item {
        @XmlAttribute
        private final Jid jid;
        private final String first;
        private final String last;
        private final String nick;
        private final String email;

        private Item() {
            this.jid = null;
            this.first = null;
            this.last = null;
            this.nick = null;
            this.email = null;
        }

        public Item(Jid jid, String first, String last, String nick, String email) {
            this.jid = Objects.requireNonNull(jid);
            this.first = first;
            this.last = last;
            this.nick = nick;
            this.email = email;
        }

        public final String getFirst() {
            return this.first;
        }

        public final String getLast() {
            return this.last;
        }

        public final String getNick() {
            return this.nick;
        }

        public final String getEmail() {
            return this.email;
        }

        public final Jid getJid() {
            return this.jid;
        }
    }
}

