/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.seclabel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.extensions.seclabel.model.catalog.Catalog;
import rocks.xmpp.extensions.seclabel.model.ess.EssSecurityLabel;

@XmlSeeAlso(value={Catalog.class, EssSecurityLabel.class})
@XmlRootElement(name="securitylabel")
public final class SecurityLabel {
    public static final String NAMESPACE = "urn:xmpp:sec-label:0";
    @XmlElement(name="displaymarking")
    private final DisplayMarking displayMarking;
    @XmlElement(name="label")
    private final Label label;
    @XmlElement(name="equivalentlabel")
    private final List<Label> equivalentLabels = new ArrayList<Label>();

    public SecurityLabel() {
        this(null);
    }

    public SecurityLabel(Object primaryLabel) {
        this(primaryLabel, null);
    }

    public SecurityLabel(Object primaryLabel, DisplayMarking displayMarking) {
        this(primaryLabel, null, displayMarking);
    }

    public SecurityLabel(Object primaryLabel, Collection<Object> equivalentLabels, DisplayMarking displayMarking) {
        this.label = new Label(primaryLabel);
        this.displayMarking = displayMarking;
        if (equivalentLabels != null) {
            this.equivalentLabels.addAll(equivalentLabels.stream().map(x$0 -> new Label(x$0)).collect(Collectors.toList()));
        }
    }

    public final DisplayMarking getDisplayMarking() {
        return this.displayMarking;
    }

    public final Object getLabel() {
        return this.label != null ? this.label.securityLabel : null;
    }

    public final List<Object> getEquivalentLabels() {
        List labels = this.equivalentLabels.stream().map(label -> ((Label)label).securityLabel).collect(Collectors.toList());
        return Collections.unmodifiableList(labels);
    }

    private static final class Label {
        @XmlAnyElement(lax=true)
        private final Object securityLabel;

        private Label() {
            this.securityLabel = null;
        }

        private Label(Object securityLabel) {
            this.securityLabel = securityLabel;
        }
    }

    public static final class DisplayMarking {
        @XmlAttribute(name="bgcolor")
        private final String bgcolor;
        @XmlAttribute(name="fgcolor")
        private final String fgcolor;
        @XmlValue
        private final String value;

        private DisplayMarking() {
            this.value = null;
            this.fgcolor = null;
            this.bgcolor = null;
        }

        public DisplayMarking(String value) {
            this(value, null, null);
        }

        public DisplayMarking(String value, String foregroundColor, String backgroundColor) {
            this.value = Objects.requireNonNull(value);
            this.fgcolor = foregroundColor;
            this.bgcolor = backgroundColor;
        }

        public final String getForegroundColor() {
            return this.fgcolor;
        }

        public final String getBackgroundColor() {
            return this.bgcolor;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

