/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.address.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.address.model.Address;

@XmlRootElement
public final class Addresses {
    private final List<Address> address = new ArrayList<Address>();

    private Addresses() {
    }

    public Addresses(Collection<Address> addresses) {
        this.address.addAll(addresses);
    }

    public Addresses(Address ... address) {
        this.address.addAll(Arrays.asList(address));
    }

    public final List<Address> getAddresses() {
        return Collections.unmodifiableList(this.address);
    }

    public final Addresses deliveredAndWithoutBlindCarbonCopies() {
        return new Addresses(this.address.stream().map(Address::delivered).filter(address -> address.getType() != Address.Type.BCC).collect(Collectors.toList()));
    }

    public final boolean shouldNotReply() {
        return this.address.stream().anyMatch(a -> a.getType() == Address.Type.NOREPLY);
    }

    public static boolean createReply(Message original, Message reply) {
        Addresses addresses = (Addresses)original.getExtension(Addresses.class);
        if (addresses == null) {
            return false;
        }
        if (addresses.shouldNotReply()) {
            return false;
        }
        ArrayList<Address> addressList = new ArrayList<Address>();
        Jid sender = original.getFrom() != null ? original.getFrom().asBareJid() : null;
        Jid receiver = original.getTo() != null ? original.getTo().asBareJid() : null;
        boolean containsOriginalSender = false;
        for (Address addr : addresses.address) {
            if (addr.getJid() == null) continue;
            if (addr.getType() == Address.Type.REPLYTO) {
                reply.setTo(addr.getJid());
                if (original.getThread() != null) {
                    reply.setThread(original.getThread());
                }
                return true;
            }
            if (addr.getType() == Address.Type.REPLYROOM) {
                return false;
            }
            Jid bareJid = addr.getJid().asBareJid();
            if (!bareJid.equals(receiver)) {
                addressList.add(addr.undelivered());
            }
            if (!bareJid.equals(sender)) continue;
            containsOriginalSender = true;
        }
        if (!containsOriginalSender) {
            addressList.add(0, new Address(Address.Type.TO, sender, new Object[0]));
        }
        reply.putExtension((Object)new Addresses(addressList));
        return true;
    }
}

