/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.colors;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class ConsistentColor {
    private static final float KR = 0.299f;
    private static final float KG = 0.587f;
    private static final float KB = 0.114f;
    private final float red;
    private final float green;
    private final float blue;

    private ConsistentColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static ConsistentColor generate(CharSequence input) {
        return ConsistentColor.generate(input, ColorVisionDeficiency.NONE);
    }

    public static ConsistentColor generate(CharSequence input, ColorVisionDeficiency colorVisionDeficiency) {
        return ConsistentColor.generate(input, colorVisionDeficiency, 0.732f);
    }

    public static ConsistentColor generate(CharSequence input, ColorVisionDeficiency colorVisionDeficiency, float y) {
        double cbAbs;
        double angle = ConsistentColor.generateAngle(input, colorVisionDeficiency);
        double cr = Math.sin(angle);
        double cb = Math.cos(angle);
        double crAbs = Math.abs(cr);
        double factor = crAbs > (cbAbs = Math.abs(cb)) ? 0.5 / crAbs : 0.5 / cbAbs;
        float r = (float)((double)1.402f * (cr *= factor) + (double)y);
        float b = (float)((double)1.772f * (cb *= factor) + (double)y);
        float g = (y - 0.299f * r - 0.114f * b) / 0.587f;
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        return new ConsistentColor(r, g, b);
    }

    static double generateAngle(CharSequence input, ColorVisionDeficiency colorVisionDeficiency) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] hash = messageDigest.digest(input.toString().getBytes(StandardCharsets.UTF_8));
            double first16Bits = (hash[1] & 0xFF) << 8 | hash[0] & 0xFF;
            double angle = first16Bits / 65535.0 * 2.0 * Math.PI;
            switch (colorVisionDeficiency) {
                case RED_GREEN_BLINDNESS: {
                    return angle / 2.0;
                }
                case BLUE_BLINDNESS: {
                    return angle / 2.0 + 1.5707963267948966;
                }
            }
            return angle;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final ConsistentColor adaptForBackground(float red, float green, float blue) {
        if (red > 1.0f || red < 0.0f) {
            throw new IllegalArgumentException("red value out of range 0.0 - 1.0");
        }
        if (green > 1.0f || green < 0.0f) {
            throw new IllegalArgumentException("green value out of range 0.0 - 1.0");
        }
        if (blue > 1.0f || blue < 0.0f) {
            throw new IllegalArgumentException("blue value out of range 0.0 - 1.0");
        }
        float ri = this.getRed();
        float gi = this.getGreen();
        float bi = this.getBlue();
        float rbInv = 1.0f - red;
        float gbInv = 1.0f - green;
        float bbInv = 1.0f - blue;
        float rc = (float)(0.2 * (double)rbInv + 0.8 * (double)ri);
        float gc = (float)(0.2 * (double)gbInv + 0.8 * (double)gi);
        float bc = (float)(0.2 * (double)bbInv + 0.8 * (double)bi);
        return new ConsistentColor(rc, gc, bc);
    }

    public final float getRed() {
        return this.red;
    }

    public final float getGreen() {
        return this.green;
    }

    public final float getBlue() {
        return this.blue;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsistentColor)) {
            return false;
        }
        ConsistentColor other = (ConsistentColor)o;
        return this.red == other.red && this.green == other.green && this.blue == other.blue;
    }

    public final int hashCode() {
        return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public final String toString() {
        int r = (int)Math.round((double)this.red * 255.0);
        int g = (int)Math.round((double)this.green * 255.0);
        int b = (int)Math.round((double)this.blue * 255.0);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static enum ColorVisionDeficiency {
        NONE,
        RED_GREEN_BLINDNESS,
        BLUE_BLINDNESS;

    }
}

