/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.apps.filetransfer.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.filetransfer.model.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.model.Range;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.jingle.apps.filetransfer.model.errors.FileTransferError;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.thumbs.model.Thumbnail;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="description")
@XmlSeeAlso(value={Received.class, Checksum.class, FileTransferError.class})
public final class JingleFileTransfer
extends ApplicationFormat {
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:file-transfer:4";
    private File file;

    private JingleFileTransfer() {
    }

    public JingleFileTransfer(File file) {
        this.file = file;
    }

    public final File getFile() {
        return this.file;
    }

    @XmlTransient
    private static abstract class InformationalMessage {
        @XmlAttribute
        private final Jingle.Content.Creator creator;
        @XmlAttribute
        private final String name;

        private InformationalMessage(Jingle.Content.Creator creator, String name) {
            this.creator = creator;
            this.name = name;
        }

        public final Jingle.Content.Creator getCreator() {
            return this.creator;
        }

        public final String getName() {
            return this.name;
        }
    }

    @XmlRootElement
    public static final class Checksum
    extends InformationalMessage {
        private final File file;

        private Checksum() {
            super(null, null);
            this.file = null;
        }

        public Checksum(Jingle.Content.Creator creator, String name, File file) {
            super(creator, name);
            this.file = file;
        }

        public final File getFile() {
            return this.file;
        }

        public final String toString() {
            return "File transfer checksum: " + this.getName() + "; " + this.file;
        }
    }

    @XmlRootElement
    public static final class Received
    extends InformationalMessage {
        private Received() {
            super(null, null);
        }

        public Received(Jingle.Content.Creator creator, String name) {
            super(creator, name);
        }

        public final String toString() {
            return "File transfer received: " + this.getName();
        }
    }

    public static final class File
    implements FileTransferOffer {
        @XmlElementRef
        private final List<Hash> hashes = new ArrayList<Hash>();
        @XmlJavaTypeAdapter(value=InstantAdapter.class)
        private final Instant date;
        private final String desc;
        @XmlElement(name="media-type")
        private final String mediaType;
        private final String name;
        private final long size;
        @XmlElementRef
        private final Thumbnail thumbnail;

        private File() {
            this.name = null;
            this.size = 0L;
            this.date = null;
            this.desc = null;
            this.mediaType = null;
            this.thumbnail = null;
        }

        public File(String name, long size) {
            this(name, size, null, null, null);
        }

        public File(String name, long size, Instant lastModified, Hash hash, String description) {
            this(name, size, lastModified, hash, description, null);
        }

        public File(String name, long size, Instant lastModified, Hash hash, String description, Thumbnail thumbnail) {
            this.name = name;
            this.size = size;
            this.date = lastModified;
            this.desc = description;
            this.mediaType = null;
            if (hash != null) {
                this.hashes.add(hash);
            }
            this.thumbnail = thumbnail;
        }

        @Override
        public final long getSize() {
            return this.size;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final List<Hash> getHashes() {
            return Collections.unmodifiableList(this.hashes);
        }

        @Override
        public final String getDescription() {
            return this.desc;
        }

        @Override
        public final Range getRange() {
            return null;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        public final Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append("Filename: ").append(this.name).append("; ");
            }
            if (this.size > 0L) {
                sb.append(this.size).append(" B; ");
            }
            if (this.desc != null) {
                sb.append("Description: ").append(this.desc).append("; ");
            }
            if (this.date != null) {
                sb.append("Last modified: ").append(this.date).append("; ");
            }
            if (!this.hashes.isEmpty()) {
                sb.append(this.hashes).append("; ");
            }
            return sb.toString();
        }
    }
}

