/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.offline.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="offline")
public final class OfflineMessage {
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private final List<Item> item = new ArrayList<Item>();
    private final String fetch;
    private final String purge;

    private OfflineMessage() {
        this.fetch = null;
        this.purge = null;
    }

    public OfflineMessage(Item ... item) {
        this(Arrays.asList(item));
    }

    public OfflineMessage(Collection<Item> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("items must not be empty");
        }
        this.item.addAll(items);
        this.fetch = null;
        this.purge = null;
    }

    public OfflineMessage(boolean fetch, boolean purge) {
        this.fetch = fetch ? "" : null;
        this.purge = purge ? "" : null;
    }

    public String getId() {
        if (!this.item.isEmpty()) {
            return this.item.get(0).getId();
        }
        return null;
    }

    public final boolean isPurge() {
        return this.purge != null;
    }

    public final boolean isFetch() {
        return this.fetch != null;
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.item);
    }

    public static final class Item {
        @XmlAttribute
        private final String node;
        @XmlAttribute
        private final Action action;

        private Item() {
            this.node = null;
            this.action = null;
        }

        public Item(String id, Action action) {
            this.node = Objects.requireNonNull(id);
            this.action = action;
        }

        public final String getId() {
            return this.node;
        }

        public final Action getAction() {
            return this.action;
        }

        @XmlEnum
        public static enum Action {
            REMOVE,
            VIEW;

        }
    }
}

